import has from "lodash/has";

import { ProgramStore } from "stores";

export const handleProgramEntryChanged = (payload) => {
  ProgramStore.update((state) => {
    if (state.items[payload.id]) {
      if (has(payload, "discussion_opened")) {
        state.items[payload.id].discussionOpened = payload.discussion_opened;
      }
      if (has(payload, "title")) {
        state.items[payload.id].title = payload.title;
      }
    }
  });
};
