const Color = require('color');

const alpha = (clr, val) => Color(clr).alpha(val).rgb().string();
const lighen = (clr, val) => Color(clr).lighten(val).rgb().string();
const darken = (clr, val) => Color(clr).darken(val).rgb().string();

module.exports = {
  theme: {
    extend: {
      maxWidth: {
        'xxs': '16rem',
      },
      gridTemplateColumns: {
        'candidate-table-row': 'auto auto auto auto 1fr'
      },
      opacity: {
        '85': '0.85',
      },
      lineHeight: {
        'negative': '0.9',
      },
      spacing: {
        '0/5': '0.125rem',
        '28': '7rem',
        '36': '9rem',
        '44': '11rem',
        '52': '13rem',
        '80': '20rem'
      }
    },
    // Breakpoints
    screens: {
      'sm': '576px',
      'md': '768px',
      'lg': '992px',
      'xl': '1200px',
      '2xl': '1366px',
    },
    fontFamily: {
      alt: ['Bebas Neue', 'Helvetica', 'Arial', 'sans-serif'],
      body: ['Roboto', 'Helvetica', 'Arial', 'sans-serif'],
      condensed: ['Roboto Condensed', 'Helvetica', 'Arial', 'sans-serif'],
    },
    fontSize: {
      '2xs': '.65rem',
      'xs': '.75rem',
      'sm': '.875rem',
      'base': '1rem',
      'lg': '1.125rem',
      'xl': '1.3rem',
      '2xl': '1.6rem',
      '3xl': '1.875rem',
      '4xl': '2.45rem',
      '5xl': '3rem',
      '6xl': '4rem',
      '7xl': '5.6rem',
    },
    fontWeight: {
      light: 300,
      normal: 400,
      medium: 500,
      bold: 700,
    },
    colors: {
      'transparent': 'transparent',
      'black': '#000000',
      'white': '#ffffff',
      'grey': {
        '50': '#f7f7f7',
        '100': '#f3f3f3',
        '125': '#f0f0f0',
        '150': '#00000012',
        '200': '#adadad',
        '300': '#4c4c4c',
        '400': '#343434',
        '500': '#303132',
        '600': '#262626',
        '700': '#202020',
        '800': '#1f1f1f',
      },
      'red': {
        '100': '#d6151b',
        '200': darken('#d6151b', 0.1),
      },
      'green': {
        '100': '#29bc51',
        '200': darken('#29bc51', 0.1),
        '300': darken('#29bc51', 0.18),
      },
      'brands': {
        'facebook': '#067ceb',
        'twitter': '#00c9ff',
        'gmail': '#ec230e',
        'linkedin': '#0066a9',
      }
    },
    container: {
      center: true,
      /* @note: needs to be kept in sync with tailwind css/atoms/container.pcss */
      padding: {
        default: '1rem',
        xl: '2rem',
      },
    },
    textDecorationColor: { // defaults to theme => theme('colors')
      'white': '#fff',
      'black': '#000',
    },
  },
  variants: {
    textDecorationColor: ['responsive', 'hover'],
  },
  // textStyles: theme => ({ // defaults to {}
  //   heading: {
  //     output: false, // this means there won't be a "heading" component in the CSS, but it can be extended
  //     fontWeight: theme('fontWeight.bold'),
  //     lineHeight: theme('lineHeight.tight'),
  //   },
  //   h1: {
  //     extends: 'heading', // this means all the styles in "heading" will be copied here; "extends" can also be an array to extend multiple text styles
  //     fontSize: theme('fontSize.5xl'),
  //     '@screen sm': {
  //       fontSize: theme('fontSize.6xl'),
  //     },
  //   },
  //   h2: {
  //     extends: 'heading',
  //     fontSize: theme('fontSize.4xl'),
  //     '@screen sm': {
  //       fontSize: theme('fontSize.5xl'),
  //     },
  //   },
  //   h3: {
  //     extends: 'heading',
  //     fontSize: theme('fontSize.4xl'),
  //   },
  //   h4: {
  //     extends: 'heading',
  //     fontSize: theme('fontSize.3xl'),
  //   },
  //   h5: {
  //     extends: 'heading',
  //     fontSize: theme('fontSize.2xl'),
  //   },
  //   h6: {
  //     extends: 'heading',
  //     fontSize: theme('fontSize.xl'),
  //   },
  //   link: {
  //     '&:hover': {
  //       textDecoration: 'underline',
  //     },
  //   },
  //   richText: {
  //     fontWeight: theme('fontWeight.normal'),
  //     fontSize: theme('fontSize.base'),
  //     lineHeight: theme('lineHeight.relaxed'),
  //     '> * + *': {
  //       marginTop: '1em',
  //     },
  //     'h1': {
  //       extends: 'h1',
  //     },
  //     'h2': {
  //       extends: 'h2',
  //     },
  //     'h3': {
  //       extends: 'h3',
  //     },
  //     'h4': {
  //       extends: 'h4',
  //     },
  //     'h5': {
  //       extends: 'h5',
  //     },
  //     'h6': {
  //       extends: 'h6',
  //     },
  //     'ul': {
  //       listStyleType: 'disc',
  //     },
  //     'ol': {
  //       listStyleType: 'decimal',
  //     },
  //     'a': {
  //       extends: 'link',
  //     },
  //     'b, strong': {
  //       fontWeight: theme('fontWeight.bold'),
  //     },
  //     'i, em': {
  //       fontStyle: 'italic',
  //     },
  //   },
  // }),
  plugins: [
    require('tailwind-css-variables')(
      {
        // modules
      },
      {
        // options
      }
    ),
    require('tailwindcss-typography')({
      // all these options default to the values specified here
      ellipsis: false,         // whether to generate ellipsis utilities
      hyphens: false,          // whether to generate hyphenation utilities
      kerning: false,          // whether to generate kerning utilities
      textUnset: false,        // whether to generate utilities to unset text properties
      componentPrefix: 'typeset-',  // the prefix to use for text style classes
    }),
    require('tailwindcss-elevation')(['responsive', 'hover'], {
      color: "#dddddd",
      opacityBoost: '0.23',
    }),
  ]
}
