#!/bin/bash

VERSION=$1

if [ -z "$VERSION" ]
then
      echo "Please specify a new version in argument"
      exit 1
fi

CURRENT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
PROJECT_DIR="$CURRENT_DIR/.."
DIST_DIR="$PROJECT_DIR/dist"

mkdir -p $DIST_DIR

rm -f "$DIST_DIR/latest.tgz" &&
  rm -rf "$DIST_DIR/latest" &&
  cp -rf "$PROJECT_DIR/public" "$DIST_DIR/latest"
  tar -czf "$DIST_DIR/latest.tgz" -C "$DIST_DIR" latest &&
  mv "$DIST_DIR/latest" "$DIST_DIR/$VERSION"
  tar -czf "$DIST_DIR/$VERSION.tgz" -C "$DIST_DIR" $VERSION &&
  rm -rf "$DIST_DIR/$VERSION" &&
  echo "New version ${VERSION} is ready as $DIST_DIR/$VERSION.tgz, please add it to repository."
