# Generated by Django 4.1.4 on 2023-04-17 10:56

import django.db.models.deletion
import markdownx.models
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Lecture",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Datum a čas konání"
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("recommended", "Doporučené"),
                            ("optional", "Volitelné"),
                        ],
                        max_length=11,
                        verbose_name="Typ",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Název")),
                (
                    "description",
                    markdownx.models.MarkdownxField(
                        blank=True,
                        help_text="Můžeš použít markdown.",
                        null=True,
                        verbose_name="Popis",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lekce",
                "verbose_name_plural": "Lekce",
            },
        ),
        migrations.CreateModel(
            name="Material",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Název")),
                (
                    "link",
                    models.URLField(
                        blank=True, max_length=256, null=True, verbose_name="Odkaz"
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        blank=True, null=True, upload_to="", verbose_name="Soubor"
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="materials",
                        to="lectures.lecture",
                        verbose_name="Událost",
                    ),
                ),
            ],
            options={
                "verbose_name": "Materiál",
                "verbose_name_plural": "Materiály",
            },
        ),
        migrations.CreateModel(
            name="LectureRecording",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Název")),
                (
                    "link",
                    models.URLField(
                        blank=True, max_length=256, null=True, verbose_name="Odkaz"
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="recordings",
                        to="lectures.lecture",
                        verbose_name="Událost",
                    ),
                ),
            ],
            options={
                "verbose_name": "Nahrávka",
                "verbose_name_plural": "Nahrávky",
            },
        ),
        migrations.CreateModel(
            name="LectureLector",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Jméno")),
                (
                    "link",
                    models.URLField(
                        blank=True, max_length=256, null=True, verbose_name="Odkaz"
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lectors",
                        to="lectures.lecture",
                        verbose_name="Událost",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lektor",
                "verbose_name_plural": "Lektoři",
            },
        ),
    ]
