package PZ::Schema::ResultSet::Shortcut;

use strict;
use warnings;

use base 'DBIx::Class::ResultSet';

use Data::Random qw(rand_chars);

use constant SIZE => 4;

sub generate {
    my $class  = shift;
    my $custom = shift;

    return $custom if $custom;

    my $shortcut;

    while ( 1 ) {
        $shortcut = rand_chars( set => 'loweralpha', size => SIZE );

        my $exists = $class->search({
            shortcut => $shortcut
        })->count;

        last if ! $exists;
    }

    return $shortcut;

}

1;
