package PZ::Schema::Result::User;

use strict;
use warnings;

use base 'DBIx::Class::Core';

use Data::Random qw(rand_chars);

our $VERSION = 1;

__PACKAGE__->table('users');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        uuid
        created
        deleted
        is_active
        username
        displayname
        token
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraint(
    'uuid' => [qw(uuid)]
);

__PACKAGE__->add_unique_constraint(
    'token' => [qw(token)]
);

__PACKAGE__->has_many(
    shortcuts => 'PZ::Schema::Result::Shortcut',
    { 'foreign.user_id' => 'self.id', },
);

sub set_token {
    my $self = shift;
    my $new  = shift;

    return if $self->token and not $new;

    my $token = rand_chars( set => 'alphanumeric', size => 32 );

    $self->update({
        token => $token
    });
}

1;
