package PZ::Schema::Result::Shortcut;

use strict;
use warnings;

use base 'DBIx::Class::Core';

use Data::Random qw(rand_chars);

our $VERSION = 1;

__PACKAGE__->table('shortcuts');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        user_id
        created
        deleted
        is_active
        shortcut
        url
        code
        title
        description
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraint(
    'shortcut' => [qw(shortcut)]
);

__PACKAGE__->has_many(
    log_items => 'PZ::Schema::Result::Log',
    { 'foreign.shortcut_id' => 'self.id', },
);

__PACKAGE__->has_many(
    stat_hourly_items => 'PZ::Schema::Result::StatHourly',
    { 'foreign.shortcut_id' => 'self.id', },
);

__PACKAGE__->has_many(
    stat_daily_items => 'PZ::Schema::Result::StatDaily',
    { 'foreign.shortcut_id' => 'self.id', },
);

1;

