package PZ::Helpers::OIDC;

use strict;
use warnings;

use constant KEY_FORMAT => "-----BEGIN PUBLIC KEY-----\n%s\n-----END PUBLIC KEY-----";

use base 'Mojolicious::Plugin';
use Mojo::JWT;
use Mojo::UserAgent;
use YAML;

sub register {
    my ($class, $self) = @_;

    my ($jwt, $discovered);

    my $ua  = Mojo::UserAgent->new();

    # get public key

    my $tx  = $ua->get( $self->cfg->{oidc}{realm_url} );
    my $res = $tx->result;

    if ($res->is_success) {
        $jwt = Mojo::JWT->new(
            public => sprintf( KEY_FORMAT,  $res->json->{public_key} )
        );
    }

    # get endpoints

    $tx  = $ua->get( $self->cfg->{oidc}{realm_well_known} );
    $res = $tx->result;

    if ($res->is_success) {
        $discovered = $res->json;
    }

    my $oidc = Net::OAuth2::Profile::WebServer->new(
       %{ $self->cfg->{oidc}},
       authorize_url     => $discovered->{authorization_endpoint},
       access_token_url  => $discovered->{token_endpoint},
    );
    $self->helper( oidc => sub { return $oidc; } );

    $self->helper( oauth_claims => sub {
        my $c     = shift;
        my $token = shift // return undef;

        return undef if ! $jwt;

        my $claims;
        eval { $claims = $jwt->decode( $token );  };

        if ( $@ ) {
            $c->app->log->warn( $@ );
            return undef;
        }

        if ( Mojo::JWT->now() > $claims->{exp} ) {
            $c->app->log->warn( 'Token expire' );
            return undef;
        }

        return $claims;

    });

    $self->helper( oauth_roles => sub {
        my $c      = shift;
        my $claims = shift;

        return $claims->{resource_access}{$self->cfg->{oidc}{client_id}}{roles};
    });

    $self->helper( oauth_groups => sub {
        my $c      = shift;
        my $claims = shift;

        return $claims->{groups} // [] ;

    });
}

1;

__END__
