package PZ::Helpers::Core;

use base 'Mojolicious::Plugin';

use YAML;

sub register  {
    my ($class, $self ) = @_;

    $self->helper(error => sub {
        my $c      = shift;
        my $status = shift;
        my $errors = [];

        $c->cirpack_ws->rollback();

        if ( scalar @_ == 2 ) {
            $errors = [{ code => shift, message => shift }];
        }
        elsif ( ref $_[0] eq 'ARRAY' ) {
            $errors = shift;
        }
        elsif ( ref $_[0] eq 'HASH' ) {
            $errors = [ shift ];
        }
        else {
            $errors = [{ message => shift, code => undef }];
        }

        $c->stash(
            status  => $status,
            openapi => { errors => $errors }
        );

        return undef;
    });

    $self->helper( trace => sub {
        my $c      = shift;
        my $data   = shift // '';

        $data = Dump $data if ref $data;
        $c->app->log->debug($data);

    });

    $self->helper( spec_filter => sub {
        my $c     = shift;
        my $data  = shift;
        my $class = shift;

        if (my $def =$c->openapi->spec("/components/schemas/$class")) {
            my $filtered = {};

            KEY:
            foreach my $key ( keys %{ $def->{properties} } ) {
                my $value    = $data->{$key};
                my $nullable = 0;

                my $types = $def->{properties}{$key}{type};

                if ( ref $types eq 'ARRAY' ) {
                    TYPE:
                    foreach my $type ( @{ $types } ) {
                        $nullable = 1, last if $type eq 'null';
                    }
                }

                if ( $key =~ /^cirpack_/ && $value eq 'XXX' ) {
                    $value  = $nullable ? undef : '';
                }

                $filtered->{$key} = $value;
            }

            $data = $filtered;

        }

        return $data;
    });

}

1;

