package PZ::Controller::Stat;
use Mojo::Base 'Mojolicious::Controller', -signatures;

use DateTime;

sub main ($c) {
    my $shortcut = $c->stash->{user}->shortcuts({
        id => $c->stash->{id}
    })->first;

    return $c->error(404, 'NOT_FOUND') if ! $shortcut;

    my %tz = (time_zone => 'Europe/Prague');
    my $begin = DateTime->from_epoch(%tz, epoch => $c->param('begin') / 1000);
    my $end   = DateTime->from_epoch(%tz, epoch => $c->param('end') / 1000);

    my ($stat, @result);

    $stat = $shortcut->stat_daily_items(period => {
          between => [$begin, $end]
    });

    ITEM:
    while ( my $item = $stat->next ) {
        push @result, {
            period => $item->period,
            count  => $item->count,
        };
    }

    $c->render(json =>  \@result );
}

1;
