package PZ::Controller::OIDC;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use YAML;

sub callback ($c) {
    my $token = $c->oidc->get_access_token($c->param("code"));

    # TODO: ERROR HANDLING

    my $claims  = $c->oauth_claims( $token->access_token );

    $c->session->{refresh_token} = $token->refresh_token;

    $c->session->{user} = {
        uuid        => $claims->{sub},
        displayname => $claims->{name},
        username    => $claims->{preferred_username},
    };

    my $user = $c->schema->resultset('User')->update_or_create(
        $c->session->{user},
        { key => 'uuid', }
    );
    $user->set_token();

    $c->session->{user}{id}     = $user->id;
    $c->session->{user}{token}  = $user->token;

    $c->authenticate();
    $c->redirect_to('/');
}

sub do_logout($c) { # nesmi se jmenovat logout - rekurze
    $c->logout;
    delete $c->session->{user};
    $c->redirect_to('/');
}

1;
