package PZ::Controller::Log;
use Mojo::Base 'Mojolicious::Controller', -signatures;

sub main ($c) {
    $c->openapi->valid_input or return;

    my $shortcut = $c->stash->{user}->shortcuts({
        id => $c->stash->{id}
    })->first;

    return $c->error(404, 'NOT_FOUND') if ! $shortcut;

    my ($log, @result);

    $log = $shortcut->log_items({},
        {
            order_by => { -desc => 'time'},
            rows     => $c->param('page_size'),
            offset   => $c->param('page_size') * ( $c->param('page_index') - 1 ),
        }
    );

    ITEM:
    while ( my $item = $log->next ) {
        push @result, {
            time     => $item->time,
            ip       => $item->ip,
            ua       => $item->ua,
            referrer => $item->referrer,
        };
    }

    $c->render(json =>  \@result );
}

sub csv ($c) {

    my $shortcut = $c->current_user->shortcuts({
        id => $c->stash->{id}
    })->first;

    return $c->error(404, 'NOT_FOUND') if ! $shortcut;

    my ($log, @result);

    $log = $shortcut->log_items({},
        {
            order_by => { 'time'},
        }
    );

    $c->res->headers->content_type('text/csv');
    $c->res->headers->content_disposition(
        'attachment; filename=log.csv',
    );
    $c->render(
        template =>'log.csv',
        log      => $log,
    );
}
1;

