# Generated by Django 3.0.8 on 2020-07-24 02:35

import django.db.models.deletion
import modelcluster.contrib.taggit
import modelcluster.fields
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks
import wagtailmetadata.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0045_assign_unlock_grouppagepermission"),
        ("taggit", "0003_taggeditem_add_unique_index"),
        ("wagtailimages", "0022_uploadedimage"),
    ]

    operations = [
        migrations.CreateModel(
            name="Program2021HomePage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
            ],
            options={"verbose_name": "Program 2021",},
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="Program2021PointPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "public_title",
                    models.CharField(
                        blank=True,
                        help_text="Navrhují markeťáci. Max 46 znaků.",
                        max_length=46,
                        null=True,
                        verbose_name="veřejný název",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        blank=True,
                        help_text="Ideálně jedno nebo dvě slova ke krátkému neformálnímu označení tématu. Max 20 znaků.",
                        max_length=20,
                        null=True,
                        verbose_name="kód",
                    ),
                ),
                (
                    "annotation",
                    models.TextField(
                        blank=True,
                        help_text="Text anotace by měl jasně prezentovat přínos a být dostatečně konkrétní, a to i když konkrétní parametr může být předmětem podrobnějších analýz a diskuse. Anotace má až na výjimky obsahovat konkrétní číslo reprezentující rozsah problému nebo přínos jeho řešení (v tomto případě ušetření 4 miliard). Tato část bodu společně s veřejným názvem je schvalována republikovým výborem jako závazný program do voleb. Max 140 znaků.",
                        max_length=140,
                        null=True,
                        verbose_name="anotace",
                    ),
                ),
                (
                    "problem",
                    models.TextField(
                        blank=True,
                        help_text="Stručné vystižení podstaty problému ve vztahu k celé společnosti a klíčové cílové skupině. Může jít o budoucí hrozbu, náklady na odkládání či dosud nevyužitou příležitost. Max 280 znaků",
                        max_length=280,
                        null=True,
                        verbose_name="problém",
                    ),
                ),
                (
                    "ideal",
                    models.TextField(
                        blank=True,
                        help_text="Max 280 znaků.",
                        max_length=280,
                        null=True,
                        verbose_name="ideál",
                    ),
                ),
                (
                    "benefits_self_employed",
                    models.TextField(
                        blank=True,
                        help_text="Stručný popis dopadu na danou cílovou skupinu. Max 140 znaků.",
                        max_length=250,
                        null=True,
                        verbose_name="benefity OSVČ",
                    ),
                ),
                (
                    "benefits_companies",
                    models.TextField(
                        blank=True,
                        help_text="Stručný popis dopadu na danou cílovou skupinu. Max 140 znaků.",
                        max_length=250,
                        null=True,
                        verbose_name="benefity firmy",
                    ),
                ),
                (
                    "benefits_public_money",
                    models.TextField(
                        blank=True,
                        help_text="Rozpracuje tým finance. Úkolem finančního týmu není zpracovat to, ale dát k tomu metodiku a metodickou pomoc. V případě žádosti o pomoc se obracejte prosím na finančního analytika poslaneckého klubu Tomáše Kopečného. Max 140 znaků.",
                        max_length=250,
                        null=True,
                        verbose_name="benefity veřejné finance",
                    ),
                ),
                (
                    "already_done",
                    wagtail.core.fields.RichTextField(
                        blank=True,
                        help_text="Max 1800 znaků.",
                        max_length=1800,
                        null=True,
                        verbose_name="co jsme už udělali",
                    ),
                ),
                (
                    "proposals",
                    wagtail.core.fields.RichTextField(
                        blank=True,
                        help_text="Konkrétní (!) body specifikující náš postup v chronologickém pořadí. Max 1800 znaků.",
                        max_length=1800,
                        null=True,
                        verbose_name="navrhovaná opatření",
                    ),
                ),
                (
                    "implementation_time",
                    models.CharField(
                        blank=True,
                        help_text="Doba, po které se projekt převede do standardního procesního řízení a lze vyhodnotit přinášený efekt. Jde pouze o realizační fázi, nikoliv celý životní cyklus.",
                        max_length=20,
                        null=True,
                        verbose_name="časový horizont realizace",
                    ),
                ),
                (
                    "faq",
                    wagtail.core.fields.StreamField(
                        [
                            (
                                "item",
                                wagtail.core.blocks.StructBlock(
                                    [
                                        (
                                            "question",
                                            wagtail.core.blocks.CharBlock(
                                                label="otázka"
                                            ),
                                        ),
                                        (
                                            "answer",
                                            wagtail.core.blocks.TextBlock(
                                                label="odpověď"
                                            ),
                                        ),
                                    ],
                                    label="dotaz",
                                ),
                            )
                        ],
                        blank=True,
                        verbose_name="často kladené dotazy",
                    ),
                ),
                (
                    "sources",
                    wagtail.core.fields.RichTextField(
                        blank=True,
                        help_text="Naše vlastní údaje (odhady), které nevycházejí přímo z renomovaného zdroje, dokládáme vlastními analýzami na dané téma, které jsou v seznamu zdrojů a měly by procházet externí oponenturou.",
                        null=True,
                        verbose_name="zdroje",
                    ),
                ),
                (
                    "related",
                    wagtail.core.fields.StreamField(
                        [
                            (
                                "point",
                                wagtail.core.blocks.PageChooserBlock(
                                    label="programový bod",
                                    page_type=["program2021.Program2021PointPage"],
                                ),
                            )
                        ],
                        blank=True,
                        verbose_name="související body",
                    ),
                ),
                (
                    "images",
                    wagtail.core.fields.StreamField(
                        [
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    label="ilustrační obrázek"
                                ),
                            )
                        ],
                        blank=True,
                        verbose_name="ilustrační obrázky",
                    ),
                ),
                (
                    "owner_name",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="jméno garanta (zodpovědné osoby)",
                    ),
                ),
                (
                    "owner_url",
                    models.URLField(
                        blank=True, null=True, verbose_name="odkaz na garanta"
                    ),
                ),
                (
                    "search_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="wagtailimages.Image",
                        verbose_name="Search image",
                    ),
                ),
            ],
            options={"verbose_name": "Programový bod",},
            bases=(
                "wagtailcore.page",
                wagtailmetadata.models.MetadataMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="Program2021PointPageTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content_object",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="program2021.Program2021PointPage",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="program2021_program2021pointpagetag_items",
                        to="taggit.Tag",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.AddField(
            model_name="program2021pointpage",
            name="tags",
            field=modelcluster.contrib.taggit.ClusterTaggableManager(
                blank=True,
                help_text="A comma-separated list of tags.",
                through="program2021.Program2021PointPageTag",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
    ]
