from django.core.management.base import BaseCommand

from district.models import DistrictProgramPage
from redmine_utils.functions import fill_data_from_redmine_for_page
from region.models import RegionProgramPage


class Command(BaseCommand):
    def handle(self, *args, **options):
        """
        Pro updated_models (DistrictProgramPage, RegionProgramPage) projedu obsah,
        zda má v sobě `redmine_program_block` - ten má IntegerBlock `redmine_issue`.
        Podle něj pak stahujeme data z Redmine.
        """
        updated_models = DistrictProgramPage, RegionProgramPage
        self.stdout.write("Updating Redmine issues...")

        for model in updated_models:
            for page in model.objects.all():
                fill_data_from_redmine_for_page(page)
                page.save()

        self.stdout.write("\nUpdating Redmine issues finished")
