# Generated by Django 4.1.4 on 2023-03-16 21:56

import django.db.models.deletion
from django.db import migrations, models

import contracts.models


class Migration(migrations.Migration):
    dependencies = [
        ("contracts", "0002_alter_contractee_address_country_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ContractContracteeRepresentative",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "function",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Funkce"
                    ),
                ),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contractee_representatives",
                        to="contracts.contract",
                        verbose_name="Smlouva",
                    ),
                ),
                (
                    "contractee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contractee_representatives",
                        to="contracts.contractee",
                        verbose_name="Naše smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zástupce naší smluvní strany",
                "verbose_name_plural": "Zástupci naší smluvní strany",
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContractSigneeRepresentative",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "function",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Funkce"
                    ),
                ),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signee_representatives",
                        to="contracts.contract",
                        verbose_name="Smlouva",
                    ),
                ),
                (
                    "signee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="representatives",
                        to="contracts.signee",
                        verbose_name="Druhá smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zástupce druhé smluvní strany",
                "verbose_name_plural": "Zástupci druhé smluvní strany",
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.RemoveField(
            model_name="signeerepresentative",
            name="signee",
        ),
        migrations.DeleteModel(
            name="ContracteeRepresentative",
        ),
        migrations.DeleteModel(
            name="SigneeRepresentative",
        ),
    ]
