from django.urls import path

from . import models, views

app_name = "contracts"
urlpatterns = [
    path("", views.index, name="index"),
    path("contracts/<int:id>", views.view_contract, name="view_contract"),
    path(
        "contracts/filing-areas/<int:id>",
        views.view_contract_filing_area,
        name="view_contract_filing_area",
    ),
    path(
        "contracts/issues/<int:id>",
        views.view_contract_issue,
        name="view_contract_issue",
    ),
    path(
        "contracts/types/<int:id>", views.view_contract_type, name="view_contract_type"
    ),
    path(
        "contracts/filing-areas",
        views.view_contract_filing_areas,
        name="view_contract_filing_areas",
    ),
    path("contracts/issues", views.view_contract_issues, name="view_contract_issues"),
    path("contracts/types", views.view_contract_types, name="view_contract_types"),
    path(
        "contracts/files/<str:pk>",
        views.ContractFileDownloadView.as_view(),
        name="download_contract_file",
    ),
    path("contractees", views.view_contractees, name="view_contractees"),
    path("signee", views.view_signees, name="view_signees"),
    path("contractees/<int:id>", views.view_contractee, name="view_contractee"),
    path("signee/<int:id>", views.view_signee, name="view_signee"),
    path(
        "ares-info-proxy/<int:ico>",
        views.get_ares_info,
        name="get_ares_info",
    ),
]
