import $ from "jquery";

import alertify from "alertifyjs";
import "alertifyjs/build/css/alertify.min.css";

$(window).ready(
    () => {
        let startDateWarningDismissed = false;
        let endDateWarningDismissed = false;

        $(".field-publishing_rejection_comment").
        css(
            "display",
            (
                (!$("#id_is_public").is(":checked")) ?
                "block": "none"
            )
        );

        $("#id_is_public").on(
            "change",
            event => {
                $(".field-publishing_rejection_comment").
                css(
                    "display",
                    (
                        (!$(event.target).is(":checked")) ?
                        "block" : "none"
                    )
                );
            }
        );

        $(
            "#contract_form .submit-row input[name=\"_save\"],"
            + "#contract_form .submit-row input[name=\"_addanother\"],"
            + "#contract_form .submit-row input[name=\"_continue\"]"
        ).on(
            "click",
            event => {
                if (!startDateWarningDismissed && $("#id_valid_start_date").val() === "") {
                    event.preventDefault();

                    alertify.alert(
                        "Začátek platnosti není zadán",
                        `Začátek platnosti nebyl uveden. Pokud ho necháš tak, jak je,
bude automaticky vyplněn podle posledního data
podpisu smluvních stran. Pokud podpisy neexistují,
pole zůstane prázdné.`,
                        () => {
                            startDateWarningDismissed = true;
                        }
                    );
                }

                if (!endDateWarningDismissed && $("#id_valid_end_date").val() === "") {
                    event.preventDefault();

                    alertify.alert(
                        "Konec platnosti není zadán",
                        `Konec platnosti nebyl uveden. Pokud ho necháš tak, jak je,
smlouva bude evidována jako na dobu neurčitou.`,
                        () => {
                            endDateWarningDismissed = true;
                        }
                    );
                }
            }
        )
    }
);
