import dal.autocomplete
from django.urls import path

from . import models, views

app_name = "contracts"
urlpatterns = [
    path("", views.index, name="index"),
    path("contracts/<int:id>", views.view_contract, name="view_contract"),
    path(
        "contracts/filing-areas/<int:id>",
        views.view_contract_filing_area,
        name="view_contract_filing_area",
    ),
    path(
        "contracts/issues/<int:id>",
        views.view_contract_issue,
        name="view_contract_issue",
    ),
    path(
        "contracts/types/<int:id>", views.view_contract_type, name="view_contract_type"
    ),
    path(
        "contracts/filing-areas",
        views.view_contract_filing_areas,
        name="view_contract_filing_areas",
    ),
    path("contracts/issues", views.view_contract_issues, name="view_contract_issues"),
    path("contracts/types", views.view_contract_types, name="view_contract_types"),
    path(
        "contracts/files/<str:pk>",
        views.ContractFileDownloadView.as_view(),
        name="download_contract_file",
    ),
    path("contractees", views.view_contractees, name="view_contractees"),
    path("signee", views.view_signees, name="view_signees"),
    path("contractees/<int:id>", views.view_contractee, name="view_contractee"),
    path("signee/<int:id>", views.view_signee, name="view_signee"),
    path(
        "contracts/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Contract),
        name="select2_djhacker_contract_autocomplete",
    ),
    path(
        "contracts/issues/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractIssue),
        name="select2_djhacker_contract_issue_autocomplete",
    ),
    path(
        "contracts/filing-areas/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractFilingArea),
        name="select2_djhacker_contract_filing_area_autocomplete",
    ),
    path(
        "contracts/types/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractType),
        name="select2_djhacker_contract_type_autocomplete",
    ),
    path(
        "contracts/signees/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Signee),
        name="select2_djhacker_signee_autocomplete",
    ),
    path(
        "contracts/contractees/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Contractee),
        name="select2_djhacker_contractee_autocomplete",
    ),
    path(
        "contracts/signees/signatures/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.SigneeSignature),
        name="select2_djhacker_signee_signature_autocomplete",
    ),
    path(
        "contracts/contractees/signatures/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContracteeSignature),
        name="select2_djhacker_contractee_signature_autocomplete",
    ),
    path(
        "ares-info-proxy/<int:ico>",
        views.get_ares_info,
        name="get_ares_info",
    ),
]
