import dal.autocomplete
import djhacker
from django import forms
from django.core.exceptions import ValidationError
from webpack_loader.loader import WebpackLoader

from .models import Contract, ContracteeSignature, SigneeSignature


class ContractAdminForm(forms.ModelForm):
    class Media:
        js = (
            "shared/runtime.js",
            "shared/shared.js",
            "shared/admin_contract_form.js",
        )

    class Meta:
        widgets = {
            "summary": forms.Textarea(attrs={"rows": 2}),
        }


class ContractFileAdminForm(forms.ModelForm):
    class Media:
        js = ("shared/admin_contract_file_form.js",)

    class Meta:
        widgets = {
            "name": forms.TextInput(attrs={"list": "file-types"}),
        }


class SigneeAdminForm(forms.ModelForm):
    class Media:
        js = (
            "shared/runtime.js",
            "shared/shared.js",
            "shared/admin_signee_form.js",
        )

    def clean(self):
        cleaned_data = super().clean()

        if cleaned_data.get("entity_type") == "natural_person":
            if cleaned_data.get("ico_number") is not None:
                raise ValidationError(
                    {"ico_number": "IČO nesmí být pro fyzické osoby definováno."}
                )

            if cleaned_data.get("department") is not None:
                raise ValidationError(
                    {
                        "department": "Organizační složka nesmí být pro fyzické osoby definována."
                    }
                )

            if cleaned_data.get("date_of_birth") is None:
                raise ValidationError(
                    {
                        "date_of_birth": "Datum narození musí pro fyzické osoby být definováno."
                    }
                )

        if cleaned_data.get("entity_type") == "business_natural_person":
            if cleaned_data.get("ico_number") is None:
                raise ValidationError(
                    {
                        "ico_number": "IČO musí být pro podnikající fyzické osoby definováno."
                    }
                )

            if cleaned_data.get("department") is not None:
                raise ValidationError(
                    {
                        "department": "Organizační složka nesmí být pro podnikající fyzické osoby definována."
                    }
                )

            if cleaned_data.get("date_of_birth") is not None:
                raise ValidationError(
                    {
                        "date_of_birth": "Datum narození nesmí pro podnikající fyzické osoby být definováno."
                    }
                )

        if cleaned_data.get("entity_type") == "legal_entity":
            if cleaned_data.get("ico_number") is None:
                raise ValidationError(
                    {"ico_number": "IČO musí být pro právnické osoby definováno."}
                )

            if cleaned_data.get("date_of_birth") is not None:
                raise ValidationError(
                    {
                        "date_of_birth": "Datum narození nesmí pro právnické osoby být definováno."
                    }
                )

        return cleaned_data


# BEGIN Autocompleted Contract fields

djhacker.formfield(
    Contract.primary_contract,
    forms.ModelChoiceField,
    widget=dal.autocomplete.ModelSelect2(
        url="contracts:select2_djhacker_contract_autocomplete"
    ),
)

djhacker.formfield(
    Contract.filing_area,
    forms.ModelChoiceField,
    widget=dal.autocomplete.ModelSelect2(
        url="contracts:select2_djhacker_contract_filing_area_autocomplete"
    ),
)

djhacker.formfield(
    Contract.issues,
    forms.ModelMultipleChoiceField,
    widget=dal.autocomplete.ModelSelect2Multiple(
        url="contracts:select2_djhacker_contract_issue_autocomplete"
    ),
)

djhacker.formfield(
    Contract.types,
    forms.ModelMultipleChoiceField,
    widget=dal.autocomplete.ModelSelect2Multiple(
        url="contracts:select2_djhacker_contract_type_autocomplete"
    ),
)

# END Autocompleted Contract fields

# BEGIN Autocompleted ContracteeSignature / SigneeSignature fields

djhacker.formfield(
    ContracteeSignature.contractee,
    forms.ModelChoiceField,
    widget=dal.autocomplete.ModelSelect2(
        url="contracts:select2_djhacker_contractee_signature_autocomplete"
    ),
)

djhacker.formfield(
    SigneeSignature.signee,
    forms.ModelChoiceField,
    widget=dal.autocomplete.ModelSelect2(
        url="contracts:select2_djhacker_signee_signature_autocomplete"
    ),
)

# END Autocompleted ContracteeSignature / SigneeSignature fields
