# Generated by Django 4.1.4 on 2023-03-22 09:14

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("contracts", "0005_alter_contract_notes_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="contract",
            name="filing_area",
            field=models.ForeignKey(
                blank=True,
                help_text="Obsah není veřejně přístupný.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="contracts",
                to="contracts.contractfilingarea",
                verbose_name="Spisovna",
            ),
        ),
        migrations.AlterField(
            model_name="contract",
            name="is_approved",
            field=models.BooleanField(
                help_text="Mohou měnit jen schvalovatelé. Pokud je smlouva veřejná, schválením se vypustí ven.",
                verbose_name="Je schválená",
            ),
        ),
        migrations.AlterField(
            model_name="contract",
            name="is_public",
            field=models.BooleanField(
                help_text="Neveřejné smlouvy nejsou vidět bez přihlášení jako min. tajný čtenář.",
                verbose_name="Je veřejná",
            ),
        ),
        migrations.AlterField(
            model_name="contract",
            name="issues",
            field=models.ManyToManyField(
                blank=True,
                help_text='Veřejně nazváno "Poznámky".',
                related_name="contracts",
                to="contracts.contractissue",
                verbose_name="Problémy",
            ),
        ),
        migrations.AlterField(
            model_name="contract",
            name="types",
            field=models.ManyToManyField(
                related_name="contracts",
                to="contracts.contracttype",
                verbose_name="Typ",
            ),
        ),
        migrations.AlterField(
            model_name="contractee",
            name="address_country",
            field=models.CharField(default="CZ", max_length=256, verbose_name="Země"),
        ),
        migrations.AlterField(
            model_name="contractfile",
            name="file",
            field=models.FileField(upload_to="private/", verbose_name="Soubor"),
        ),
        migrations.AlterField(
            model_name="signee",
            name="address_country",
            field=models.CharField(default="CZ", max_length=256, verbose_name="Země"),
        ),
    ]
