# Generated by Django 4.1.4 on 2023-03-15 12:22

import django.db.models.deletion
import markdownx.models
from django.conf import settings
from django.db import migrations, models

import contracts.models
import shared.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Contract",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "all_parties_sign_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Datum podpisu všech stran"
                    ),
                ),
                (
                    "approval_state",
                    models.CharField(
                        blank=True,
                        choices=[("no", "Neschválená"), ("yes", "Schválená")],
                        help_text='Může měnit jen schvalovatel. Pokud je smlouva veřejná, se stavem "Schválená" se vypustí ven.',
                        max_length=7,
                        null=True,
                        verbose_name="Stav schválení",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Název")),
                (
                    "id_number",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="Identifikační číslo",
                    ),
                ),
                (
                    "summary",
                    models.TextField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Sumarizace obsahu smlouvy",
                    ),
                ),
                (
                    "valid_start_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Začátek účinnosti"
                    ),
                ),
                (
                    "valid_end_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Konec účinnosti"
                    ),
                ),
                (
                    "legal_state",
                    models.CharField(
                        choices=[("valid", "Platná"), ("invalid", "Neplatná")],
                        max_length=13,
                        verbose_name="Stav právního ujednání",
                    ),
                ),
                (
                    "public_state",
                    models.CharField(
                        choices=[("yes", "Veřejná"), ("no", "Neveřejná")],
                        max_length=7,
                        verbose_name="Veřejnost smlouvy",
                    ),
                ),
                (
                    "paper_form_state",
                    models.CharField(
                        choices=[
                            ("sent", "Odeslaný"),
                            ("stored", "Uložený"),
                            ("to_shred", "Ke skartaci"),
                            ("shredded", "Skartovaný"),
                            ("lost", "Ztracený"),
                        ],
                        max_length=8,
                        verbose_name="Stav fyzického dokumentu",
                    ),
                ),
                (
                    "publishing_rejection_comment",
                    models.CharField(
                        blank=True,
                        help_text="Obsah není veřejně přístupný.",
                        max_length=65536,
                        null=True,
                        verbose_name="Důvod nezveřejnění",
                    ),
                ),
                (
                    "tender_url",
                    models.URLField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Odkaz na výběrové řízení",
                    ),
                ),
                (
                    "agreement_url",
                    models.URLField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Odkaz na schválení",
                    ),
                ),
                (
                    "cost_amount",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="Náklady (Kč)"
                    ),
                ),
                (
                    "cost_unit",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("hour", "Hodina"),
                            ("month", "Měsíc"),
                            ("year", "Rok"),
                            ("total", "Celkem"),
                        ],
                        max_length=5,
                        null=True,
                        verbose_name="Jednotka nákladů",
                    ),
                ),
                (
                    "notes",
                    markdownx.models.MarkdownxField(
                        blank=True,
                        help_text="Poznámky jsou viditelné pro všechny, kteří mohou smlouvu spravovat.",
                        null=True,
                        verbose_name="Poznámky",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="Informace není veřejně přístupná. Pokud vytváříš novou smlouvu, budeš to ty.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="uploaded_contracts",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Vytvořena uživatelem",
                    ),
                ),
            ],
            options={
                "verbose_name": "Smlouva",
                "verbose_name_plural": "Smlouvy",
                "permissions": (("approve", "Schválit / zrušit schválení"),),
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Contractee",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default="Česká pirátská strana",
                        max_length=256,
                        verbose_name="Jméno",
                    ),
                ),
                (
                    "address_street_with_number",
                    models.CharField(
                        default="Na Moráni 360/3",
                        max_length=256,
                        verbose_name="Ulice, č.p.",
                    ),
                ),
                (
                    "address_district",
                    models.CharField(
                        default="Praha 2", max_length=256, verbose_name="Obec"
                    ),
                ),
                (
                    "address_zip",
                    models.CharField(
                        default="128 00", max_length=16, verbose_name="PSČ"
                    ),
                ),
                (
                    "address_country",
                    models.CharField(default="CZ", max_length=256, verbose_name="Země"),
                ),
                (
                    "ico_number",
                    models.CharField(
                        blank=True,
                        default="71339698",
                        max_length=16,
                        null=True,
                        verbose_name="IČO",
                    ),
                ),
                (
                    "department",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="Organizační složka",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Role"
                    ),
                ),
            ],
            options={
                "verbose_name": "Naše smluvní strana",
                "verbose_name_plural": "Naše smluvní strany",
            },
        ),
        migrations.CreateModel(
            name="ContractFilingArea",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
                (
                    "person_responsible",
                    models.CharField(max_length=256, verbose_name="Odpovědná osoba"),
                ),
            ],
            options={
                "verbose_name": "Spisovna",
                "verbose_name_plural": "Spisovny",
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContractIssue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
            ],
            options={
                "verbose_name": "Problém se smlouvou",
                "verbose_name_plural": "Problémy se smlouvami",
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContractType",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
            ],
            options={
                "verbose_name": "Typ smlouvy",
                "verbose_name_plural": "Typy smlouvy",
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Signee",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "entity_type",
                    models.CharField(
                        choices=[
                            ("natural_person", "Fyzická osoba"),
                            ("legal_entity", "Právnická osoba"),
                            ("business_natural_person", "Podnikající fyzická osoba"),
                            ("other", "Jiné"),
                        ],
                        default="legal_entity",
                        help_text="Důležité označit správně! Fyzickým osobám nepublikujeme adresu.",
                        max_length=23,
                        verbose_name="Typ",
                    ),
                ),
                (
                    "address_street_with_number",
                    models.CharField(
                        help_text="Veřejné pouze, když typ není nastaven na fyzickou osobu.",
                        max_length=256,
                        verbose_name="Ulice, č.p.",
                    ),
                ),
                (
                    "address_district",
                    models.CharField(max_length=256, verbose_name="Obec"),
                ),
                (
                    "address_zip",
                    models.CharField(
                        help_text="Veřejné pouze, když typ není nastaven na fyzickou osobu.",
                        max_length=16,
                        verbose_name="PSČ",
                    ),
                ),
                (
                    "address_country",
                    models.CharField(default="CZ", max_length=256, verbose_name="Země"),
                ),
                (
                    "ico_number",
                    models.CharField(
                        blank=True,
                        help_text="Vyplněním můžeš automaticky načíst data z ARES.",
                        max_length=16,
                        null=True,
                        verbose_name="IČO",
                    ),
                ),
                (
                    "date_of_birth",
                    models.DateField(
                        blank=True, null=True, verbose_name="Datum narození"
                    ),
                ),
                (
                    "department",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="Organizační složka",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Role"
                    ),
                ),
            ],
            options={
                "verbose_name": "Jiná smluvní strana",
                "verbose_name_plural": "Ostatní smluvní strany",
            },
        ),
        migrations.CreateModel(
            name="SigneeSignature",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateField(verbose_name="Datum podpisu")),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signee_signatures",
                        to="contracts.contract",
                        verbose_name="Podpisy jiných smluvních stran",
                    ),
                ),
                (
                    "signee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signatures",
                        to="contracts.signee",
                        verbose_name="Smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Podpis jiné smluvní strany",
                "verbose_name_plural": "Podpisy ostatních smluvních stran",
            },
        ),
        migrations.CreateModel(
            name="SigneeRepresentative",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "function",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Funkce"
                    ),
                ),
                (
                    "signee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="representatives",
                        to="contracts.signee",
                        verbose_name="Smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zástupce",
                "verbose_name_plural": "Zástupci",
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContractIntent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128, verbose_name="Jméno")),
                ("url", models.URLField(max_length=256, verbose_name="Odkaz")),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="intents",
                        to="contracts.contract",
                        verbose_name="Smlouva",
                    ),
                ),
            ],
            options={
                "verbose_name": "Záměr",
                "verbose_name_plural": "Záměry",
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContractFile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=128, null=True, verbose_name="Jméno"
                    ),
                ),
                (
                    "is_public",
                    models.BooleanField(default=False, verbose_name="Veřejně dostupný"),
                ),
                ("file", models.FileField(upload_to="", verbose_name="Soubor")),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="files",
                        to="contracts.contract",
                        verbose_name="Soubory",
                    ),
                ),
            ],
            options={
                "verbose_name": "Soubor",
                "verbose_name_plural": "Soubory",
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ContracteeSignature",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateField(verbose_name="Datum podpisu")),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contractee_signatures",
                        to="contracts.contract",
                        verbose_name="Podpisy našich smluvních stran",
                    ),
                ),
                (
                    "contractee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signatures",
                        to="contracts.contractee",
                        verbose_name="Smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Podpis naší smluvní strany",
                "verbose_name_plural": "Podpisy našich smluvních stran",
            },
        ),
        migrations.CreateModel(
            name="ContracteeRepresentative",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "function",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Funkce"
                    ),
                ),
                (
                    "contractee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="representatives",
                        to="contracts.contractee",
                        verbose_name="Smluvní strana",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zástupce",
                "verbose_name_plural": "Zástupci",
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.AddField(
            model_name="contract",
            name="filing_area",
            field=models.ForeignKey(
                blank=True,
                help_text="Obsah není veřejně přístupný.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="filed_contracts",
                to="contracts.contractfilingarea",
                verbose_name="Spisovna",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="issues",
            field=models.ManyToManyField(
                blank=True,
                help_text='Veřejně nazváno "Poznámky".',
                to="contracts.contractissue",
                verbose_name="Problémy",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="primary_contract",
            field=models.ForeignKey(
                blank=True,
                help_text="Např. pro dodatky nebo objednávky u rámcových smluv.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="subcontracts",
                to="contracts.contract",
                verbose_name="Primární smlouva",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="public_status_set_by",
            field=models.ForeignKey(
                blank=True,
                help_text="Obsah není veřejně přístupný.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="public_status_altered_contracts",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Zveřejněno / nezveřejněno uživatelem",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="types",
            field=models.ManyToManyField(
                to="contracts.contracttype", verbose_name="Typ"
            ),
        ),
    ]
