# Generated by Django 4.1.4 on 2023-07-01 13:37

from django.db import migrations, models


def migrate_between_fields(apps, schema) -> None:
    Contract = apps.get_model("contracts", "contract")

    from contracts.models import Contract as ContractOrignalModel

    for contract in Contract.objects.filter(is_approved=True).all():
        contract.status = ContractOrignalModel.StatusTypes.APPROVED
        contract.save()


class Migration(migrations.Migration):
    dependencies = [
        ("contracts", "0062_contract_paper_form_person_responsible"),
    ]

    operations = [
        migrations.AddField(
            model_name="contract",
            name="status",
            field=models.CharField(
                choices=[
                    ("work_in_progress", "Rozpracovaná"),
                    ("to_be_approved", "Ke schválení"),
                    ("approved", "Schválená"),
                    ("rejected", "Zamítnutá"),
                ],
                default="work_in_progress",
                help_text='Označením jako "Ke schválení" se smlouva předá schvalovateli.',
                max_length=16,
                verbose_name="Status",
            ),
        ),
        migrations.RunPython(migrate_between_fields),
        migrations.RemoveField(
            model_name="contract",
            name="is_approved",
        ),
    ]
