from django.conf import settings
from django.shortcuts import render
from django.core.paginator import Paginator

from .models import Contract

# Create your views here.


def index(request):
    contracts = Contract.objects.filter(
        is_approved__is=True,
        public_state=Contract.PublicStates.YES,  
    ).order_by("valid_start_date").all()
    paginator = Paginator(contracts, 25)
    
    page = paginator.get_page(
        request.GET.get('page')
    )
    
    return render(
        request,
        "contracts/index.html",
        {
            "site_url": settings.SITE_URL,
            "user": request.user,
            "title": "Seznam smluv",
            "description": "Description",
            "paginator": paginator,
            "page": page,
        }
    )


def view_contract(request, id: int):
    contract = Contract.objects.filter(
        is_approved__is=True,
        public_state=Contract.PublicStates.YES,
    ).get(id=id)

    return render(
        request,
        "contracts/view_contract.html",
        {
            "site_url": settings.SITE_URL,
            "user": request.user,
            "title": contract.identifier,
            "description": "",  # TODO
            "contract": contract,
        }
    )
