# Generated by Django 4.1.4 on 2023-02-20 11:46

import colorfield.fields
import contracts.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import markdownx.models
import shared.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('all_parties_sign_date', models.DateField(blank=True, null=True, verbose_name='Datum podpisu všech stran')),
                ('valid_start_date', models.DateField(verbose_name='Začátek účinnosti')),
                ('valid_end_date', models.DateField(verbose_name='Konec platnosti')),
                ('legal_state', models.CharField(choices=[('valid', 'Platná'), ('effective', 'Účinná'), ('not_effective', 'Neúčinná'), ('invalid', 'Neplatná')], max_length=13, verbose_name='Stav právního ujednání')),
                ('public_state', models.CharField(choices=[('yes', 'Veřejná'), ('no', 'Neveřejná')], max_length=7, verbose_name='Veřejnost smlouvy')),
                ('paper_form_state', models.CharField(choices=[('sent', 'Odeslaná'), ('stored', 'Uložená'), ('to_shred', 'Ke skartaci'), ('shredded', 'Skartovaná'), ('lost', 'Ztracená')], max_length=8, verbose_name='Stav papírové formy')),
                ('publishing_rejection_comment', models.CharField(blank=True, help_text='Obsah není veřejně přístupný.', max_length=65536, null=True, verbose_name='Důvod nezveřejnění')),
                ('tender_url', models.URLField(blank=True, max_length=256, null=True, verbose_name='Odkaz na výběrové řízení')),
                ('agreement_url', models.URLField(blank=True, max_length=256, null=True, verbose_name='Odkaz na schválení')),
                ('identifier', models.CharField(max_length=128, verbose_name='Identifikační číslo')),
                ('notes', markdownx.models.MarkdownxField(blank=True, help_text='Poznámky jsou viditelné pro všechny, kteří mohou smlouvu spravovat.', null=True, verbose_name='Poznámky')),
                ('summary', markdownx.models.MarkdownxField(blank=True, help_text='Obsah není veřejně přístupný.', null=True, verbose_name='Rekapitulace')),
                ('created_by', models.ForeignKey(blank=True, help_text='Informace není veřejně přístupná. Pokud vytváříš novou smlouvu, budeš to ty.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='uploaded_contracts', to=settings.AUTH_USER_MODEL, verbose_name='Vytvořena uživatelem')),
            ],
            options={
                'verbose_name': 'Smlouva',
                'verbose_name_plural': 'Smlouvy',
            },
        ),
        migrations.CreateModel(
            name='Contractee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='Česká pirátská strana', max_length=256, verbose_name='Jméno')),
                ('address_street_with_number', models.CharField(default='Na Moráni 360/3', max_length=256, verbose_name='Ulice, č.p.')),
                ('address_district', models.CharField(default='Praha 2', max_length=256, verbose_name='Obec')),
                ('address_zip', models.CharField(default='128 00', max_length=16, verbose_name='PSČ')),
                ('address_country', django_countries.fields.CountryField(default='CZ', max_length=2, verbose_name='Země')),
                ('ico_number', models.CharField(blank=True, default='71339698', max_length=16, null=True, verbose_name='IČO')),
                ('department', models.CharField(blank=True, max_length=128, null=True, verbose_name='Organizační složka')),
                ('color', colorfield.fields.ColorField(blank=True, default=None, image_field=None, max_length=18, null=True, samples=None, verbose_name='Barva')),
            ],
            options={
                'verbose_name': 'Naše smluvní strana',
                'verbose_name_plural': 'Naše smluvní strany',
            },
        ),
        migrations.CreateModel(
            name='ContractFilingArea',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, verbose_name='Jméno')),
                ('person_responsible', models.CharField(max_length=256, verbose_name='Odpovědná osoba')),
            ],
            options={
                'verbose_name': 'Spisovna',
                'verbose_name_plural': 'Spisovny',
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ContractIssue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, verbose_name='Jméno')),
            ],
            options={
                'verbose_name': 'Problém se smlouvou',
                'verbose_name_plural': 'Problémy se smlouvami',
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ContractType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, verbose_name='Jméno')),
            ],
            options={
                'verbose_name': 'Typ smlouvy',
                'verbose_name_plural': 'Typy smlouvy',
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Signee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, verbose_name='Jméno')),
                ('is_legal_entity', models.BooleanField(help_text='Důležité označit správně! Pokud není osoba právnická, zveřejňujeme pouze obec a zemi.', verbose_name='Je právnická osoba')),
                ('address_street_with_number', models.CharField(help_text='Viditelné pouze u právnických osob.', max_length=256, verbose_name='Ulice, č.p.')),
                ('address_district', models.CharField(max_length=256, verbose_name='Obec')),
                ('address_zip', models.CharField(help_text='Viditelné pouze u právnických osob.', max_length=16, verbose_name='PSČ')),
                ('address_country', django_countries.fields.CountryField(max_length=2, verbose_name='Země')),
                ('ico_number', models.CharField(blank=True, max_length=16, null=True, verbose_name='IČO')),
                ('date_of_birth', models.DateField(blank=True, null=True, verbose_name='Datum narození')),
                ('department', models.CharField(blank=True, max_length=128, null=True, verbose_name='Organizační složka')),
                ('color', colorfield.fields.ColorField(blank=True, default=None, image_field=None, max_length=18, null=True, samples=None, verbose_name='Barva')),
            ],
            options={
                'verbose_name': 'Jiná smluvní strana',
                'verbose_name_plural': 'Ostatní smluvní strany',
            },
        ),
        migrations.CreateModel(
            name='SigneeSignature',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Datum podpisu')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='signee_signatures', to='contracts.contract', verbose_name='Podpisy jiných smluvních stran')),
                ('signee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='signatures', to='contracts.signee', verbose_name='Smluvní strana')),
            ],
            options={
                'verbose_name': 'Podpis jiné smluvní strany',
                'verbose_name_plural': 'Podpisy ostatních smluvních stran',
            },
        ),
        migrations.CreateModel(
            name='SigneeRepresentative',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, verbose_name='Jméno')),
                ('function', models.CharField(blank=True, max_length=256, null=True, verbose_name='Funkce')),
                ('role', models.CharField(blank=True, max_length=256, null=True, verbose_name='Role')),
                ('signee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='representatives', to='contracts.signee', verbose_name='Smluvní strana')),
            ],
            options={
                'verbose_name': 'Zástupce',
                'verbose_name_plural': 'Zástupci',
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ContractIntent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name='Jméno')),
                ('url', models.URLField(max_length=256, verbose_name='Odkaz')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='intents', to='contracts.contract', verbose_name='Smlouva')),
            ],
            options={
                'verbose_name': 'Záměr',
                'verbose_name_plural': 'Záměry',
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ContractFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=128, null=True, verbose_name='Jméno')),
                ('is_public', models.BooleanField(default=False, verbose_name='Veřejně dostupný')),
                ('file', models.FileField(upload_to='', verbose_name='Soubor')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='contracts.contract', verbose_name='Soubory')),
            ],
            options={
                'verbose_name': 'Soubor',
                'verbose_name_plural': 'Soubory',
            },
            bases=(shared.models.NameStrMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ContracteeSignature',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Datum podpisu')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contractee_signatures', to='contracts.contract', verbose_name='Podpisy našich smluvních stran')),
                ('contractee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='signatures', to='contracts.contractee', verbose_name='Smluvní strana')),
            ],
            options={
                'verbose_name': 'Podpis naší smluvní strany',
                'verbose_name_plural': 'Podpisy našich smluvních stran',
            },
        ),
        migrations.CreateModel(
            name='ContracteeRepresentative',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, verbose_name='Jméno')),
                ('function', models.CharField(blank=True, max_length=256, null=True, verbose_name='Funkce')),
                ('role', models.CharField(blank=True, max_length=256, null=True, verbose_name='Role')),
                ('contractee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='representatives', to='contracts.contractee', verbose_name='Smluvní strana')),
            ],
            options={
                'verbose_name': 'Zástupce',
                'verbose_name_plural': 'Zástupci',
            },
            bases=(contracts.models.RepresentativeMixin, models.Model),
        ),
        migrations.AddField(
            model_name='contract',
            name='filing_area',
            field=models.ForeignKey(blank=True, help_text='Obsah není veřejně přístupný.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='filed_contracts', to='contracts.contractfilingarea', verbose_name='Spisovna'),
        ),
        migrations.AddField(
            model_name='contract',
            name='issues',
            field=models.ManyToManyField(blank=True, to='contracts.contractissue', verbose_name='Problémy'),
        ),
        migrations.AddField(
            model_name='contract',
            name='primary_contract',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='subcontracts', to='contracts.contract', verbose_name='Primární smlouva'),
        ),
        migrations.AddField(
            model_name='contract',
            name='public_status_set_by',
            field=models.ForeignKey(blank=True, help_text='Obsah není veřejně přístupný.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='public_status_altered_contracts', to=settings.AUTH_USER_MODEL, verbose_name='Zveřejněno / nezveřejněno uživatelem'),
        ),
        migrations.AddField(
            model_name='contract',
            name='types',
            field=models.ManyToManyField(to='contracts.contracttype', verbose_name='Typ'),
        ),
    ]
