from django.conf import settings
from django.core.paginator import Paginator
from django.shortcuts import render

from .models import Contract

# Create your views here.


def index(request):
    contracts = (
        Contract.objects.filter(
            approval_state=Contract.ApprovalStates.YES,
            public_state=Contract.PublicStates.YES,
        )
        .order_by("valid_start_date")
        .all()
    )
    paginator = Paginator(contracts, 25)

    page = paginator.get_page(request.GET.get("page"))

    return render(
        request,
        "contracts/index.html",
        {
            "site_url": settings.SITE_URL,
            "user": request.user,
            "title": "Seznam smluv",
            "description": "Description",
            "paginator": paginator,
            "page": page,
        },
    )


def view_contract(request, id: int):
    contract = Contract.objects.filter(
        approval_state=Contract.ApprovalStates.YES,
        public_state=Contract.PublicStates.YES,
    ).get(id=id)

    return render(
        request,
        "contracts/view_contract.html",
        {
            "site_url": settings.SITE_URL,
            "user": request.user,
            "title": contract.name,
            "description": "",  # TODO
            "contract": contract,
        },
    )
