import dal.autocomplete

from django.urls import path

from . import views, models

app_name = "contracts"
urlpatterns = [
    path("", views.index, name="index"),
    path("contracts/<int:id>", views.view_contract, name="view_contract"),
    path(
        "contracts/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Contract),
        name="select2_djhacker_contract_autocomplete",
    ),
    path(
        "contracts/issues/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractIssue),
        name="select2_djhacker_contract_issue_autocomplete",
    ),
    path(
        "contracts/filing-areas/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractFilingArea),
        name="select2_djhacker_contract_filing_area_autocomplete",
    ),
    path(
        "contracts/types/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContractType),
        name="select2_djhacker_contract_type_autocomplete",
    ),
    path(
        "contracts/signees/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Signee),
        name="select2_djhacker_signee_autocomplete",
    ),
    path(
        "contracts/contractees/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.Contractee),
        name="select2_djhacker_contractee_autocomplete",
    ),
    path(
        "contracts/signees/signatures/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.SigneeSignature),
        name="select2_djhacker_signee_signature_autocomplete",
    ),
    path(
        "contracts/contractees/signatures/autocomplete",
        dal.autocomplete.Select2QuerySetView.as_view(model=models.ContracteeSignature),
        name="select2_djhacker_contractee_signature_autocomplete",
    ),
]
