import $ from "jquery";

import alertify from "alertifyjs";
import "alertifyjs/build/css/alertify.min.css";

const fieldDepartmentValues = new Set([
    "legal_entity",
    "other",
]);

$(window).ready(
    () => {
        let selectedValue = $("#id_entity_type").find(":selected").val();
        
        let isNaturalPerson = (selectedValue === "natural_person");
        let isOther = (selectedValue === "other");
        let isEmpty = (selectedValue === "");

        $(".field-date_of_birth").
        css(
            "display",
            (
                (!isEmpty && (isNaturalPerson || isOther)) ?
                "block" : "none"
            )
        );

        $(".field-ico_number,.field-load_ares_data_button").
        css(
            "display",
            (
                (!isEmpty && !isNaturalPerson) ?
                "block" : "none"
            )
        );

        $(".field-department").
        css(
            "display",
            (
                (!isEmpty && fieldDepartmentValues.has(selectedValue)) ?
                "block" : "none"
            )
        );

        if (!isNaturalPerson && !isOther && !isEmpty) $("#id_date_of_birth").val("");
        if (isNaturalPerson) $("#id_ico_number").val("");
        if (!fieldDepartmentValues.has(selectedValue) && !isEmpty) $("#id_department").val("");

        $("#id_entity_type").on(
            "change",
            event => {
                selectedValue = $(event.target).val();
                
                isEmpty = (selectedValue === "");
                isOther = (selectedValue === "other");
                isNaturalPerson = (selectedValue === "natural_person");

                $(".field-date_of_birth").
                css(
                    "display",
                    (
                        (!isEmpty && (isNaturalPerson || isOther)) ?
                        "block" : "none"
                    )
                );
                $(".field-ico_number,.field-load_ares_data_button").
                css(
                    "display",
                    (
                        (!isEmpty && !isNaturalPerson) ?
                        "block" : "none"
                    )
                );

                $(".field-department").
                css(
                    "display",
                    (
                        (!isEmpty && fieldDepartmentValues.has($(event.target).val())) ?
                        "block" : "none"
                    )
                );

                if (!isNaturalPerson && !isOther && !isEmpty) $("#id_date_of_birth").val("");
                if (isNaturalPerson) $("#id_ico_number").val("");
                if (!fieldDepartmentValues.has($(event.target).val()) && !isEmpty) $("#id_department").val("");
            }
        );

        $("#load_ares_data").on(
            "click",
            async (event) => {
                const icoValue = $("#id_ico_number").val();

                const rawAresXMLResponse = await fetch(
                    `/ares-info-proxy/${icoValue}`
                );

                if (!rawAresXMLResponse.ok) {
                    alertify.error("Chyba při načítní dat z ARES.");

                    console.warn(
                        "Error loading ARES data: ",
                        await rawAresXMLResponse.text()
                    );

                    return;
                }

                const formattedAresData = new DOMParser().parseFromString(
                    await rawAresXMLResponse.text(),
                    "text/xml"
                );

                const errors = formattedAresData.getElementsByTagName("are:Error");

                if (errors.length !== 0) {
                    alertify.error("Chyba při načítní dat z ARES. Je IČO zadáno správně?");

                    console.warn(
                        "Error(s) loading ARES data: ",
                        errors
                    );

                    return;
                }

                let streetResult = "";

                const streetElements = formattedAresData.getElementsByTagName("dtt:Nazev_ulice");

                if (streetElements.length !== 0) {
                    streetResult += streetElements[0].innerHTML;
                }

                const houseNumberElements = formattedAresData.getElementsByTagName("dtt:Cislo_domovni");

                if (houseNumberElements.length !== 0) {
                    streetResult += ` ${houseNumberElements[0].innerHTML}`;
                }

                const orientationNumberElements = formattedAresData.getElementsByTagName("dtt:Cislo_orientacni");

                if (orientationNumberElements.length !== 0) {
                    streetResult += `/${orientationNumberElements[0].innerHTML}`;
                }

                $("#id_name").val(formattedAresData.getElementsByTagName("are:Obchodni_firma")[0].innerHTML)
                $("#id_address_street_with_number").val(streetResult);
                $("#id_address_district").val(formattedAresData.getElementsByTagName("dtt:Nazev_obce")[0].innerHTML);
                $("#id_address_zip").val(formattedAresData.getElementsByTagName("dtt:PSC")[0].innerHTML);
                // IČO numbers will always be in the Czech Republic.
                $("#id_address_country").val("Česká Republika");

                console.log(formattedAresData);
            }
        );
    }
);
