import $ from "jquery";

import alertify from "alertifyjs";
import "alertifyjs/build/css/alertify.min.css";

const fieldDepartmentValues = new Set([
    "legal_entity",
    "other",
]);

$(window).ready(
    () => {
        let selectedValue = $("#id_entity_type").find(":selected").val();

        let isNaturalPerson = (selectedValue === "natural_person");
        let isOther = (selectedValue === "other");
        let isEmpty = (selectedValue === "");

        $(".field-date_of_birth").
        css(
            "display",
            (
                (!isEmpty && (isNaturalPerson || isOther)) ?
                "block" : "none"
            )
        );

        $(".field-ico_number,.field-load_ares_data_button").
        css(
            "display",
            (
                (!isEmpty && !isNaturalPerson) ?
                "block" : "none"
            )
        );

        $(".field-department").
        css(
            "display",
            (
                (!isEmpty && fieldDepartmentValues.has(selectedValue)) ?
                "block" : "none"
            )
        );

        if (!isNaturalPerson && !isOther && !isEmpty) $("#id_date_of_birth").val("");
        if (isNaturalPerson) $("#id_ico_number").val("");
        if (!fieldDepartmentValues.has(selectedValue) && !isEmpty) $("#id_department").val("");

        $("#id_entity_type").on(
            "change",
            event => {
                selectedValue = $(event.target).val();

                isEmpty = (selectedValue === "");
                isOther = (selectedValue === "other");
                isNaturalPerson = (selectedValue === "natural_person");

                $(".field-date_of_birth").
                css(
                    "display",
                    (
                        (!isEmpty && (isNaturalPerson || isOther)) ?
                        "block" : "none"
                    )
                );
                $(".field-ico_number,.field-load_ares_data_button").
                css(
                    "display",
                    (
                        (!isEmpty && !isNaturalPerson) ?
                        "block" : "none"
                    )
                );

                $(".field-department").
                css(
                    "display",
                    (
                        (!isEmpty && fieldDepartmentValues.has($(event.target).val())) ?
                        "block" : "none"
                    )
                );

                if (!isNaturalPerson && !isOther && !isEmpty) $("#id_date_of_birth").val("");
                if (isNaturalPerson) $("#id_ico_number").val("");
                if (!fieldDepartmentValues.has($(event.target).val()) && !isEmpty) $("#id_department").val("");
            }
        );

        $("#load_ares_data").on(
            "click",
            async (event) => {
                const icoValue = $("#id_ico_number").val();

                const rawAresJSONResponse = await fetch(
                    `/ares-info-proxy/${icoValue}`
                );

                if (!rawAresJSONResponse.ok) {
                    alertify.error("Chyba při načítní dat z ARES.");

                    console.warn(
                        "Error loading ARES data: ",
                        await rawAresJSONResponse.text()
                    );

                    return;
                }

                const formattedAresData = await rawAresJSONResponse.json();

                let street = (
                    (formattedAresData["sidlo"]["nazevUlice"] !== undefined) ?
                    formattedAresData["sidlo"]["nazevUlice"] : ""
                )

                street += (
                    (formattedAresData["sidlo"]["cisloDomovni"] !== undefined) ?
                    (" " + formattedAresData["sidlo"]["cisloDomovni"]) : ""
                )
                street += (
                    (formattedAresData["sidlo"]["cisloOrientacni"] !== undefined) ?
                    ("/" + formattedAresData["sidlo"]["cisloOrientacni"]) : ""
                )

                $("#id_name").val(
                    (formattedAresData["obchodniJmeno"] !== undefined) ?
                    formattedAresData["obchodniJmeno"] : ""
                )
                $("#id_address_street_with_number").val(street);
                $("#id_address_district").val(
                    (formattedAresData["sidlo"]["nazevCastiObce"] !== undefined) ?
                    formattedAresData["sidlo"]["nazevCastiObce"] : ""
                );
                $("#id_address_zip").val(
                    (formattedAresData["sidlo"]["psc"] !== undefined) ?
                    formattedAresData["sidlo"]["psc"] : ""
                );
                // IČO numbers will always be in the Czech Republic.
                $("#id_address_country").val(
                    (formattedAresData["sidlo"]["nazevStatu"] !== undefined) ?
                    formattedAresData["sidlo"]["nazevStatu"] : ""
                );

                console.info("Loaded ARES data: ", formattedAresData);
            }
        );
    }
);
