import $ from "jquery";

$(window).ready(
    () => {
        $(".field-publishing_rejection_comment").
        css(
            "display",
            (
                (!$("#id_is_public").is(":checked")) ?
                "block": "none"
            )
        );

        $("#id_is_public").on(
            "change",
            event => {
                const publicIsSelected = $(event.target).is(":checked");

                $(".field-publishing_rejection_comment").
                css(
                    "display",
                    (
                        (!publicIsSelected) ?
                        "block" : "none"
                    )
                );

                if (publicIsSelected) $("#id_publishing_rejection_comment").val("");
            }
        );

        $(".field-cost_unit_other").
        css(
            "display",
            (
                ($("#id_cost_unit").find(":selected").val() === "other") ?
                "block": "none"
            )
        );

        $(".field-paper_form_person_responsible").
        css(
            "display",
            (
                (
                    !["never_made", "stored", "shredded", "lost"].includes(
                        $("#id_paper_form_state").find(":selected").val()
                    )
                ) ?
                "block" : "none"
            )
        );

        $(".field-filing_area").
        css(
            "display",
            (
                (
                    $("#id_paper_form_state").find(":selected").val() !== "never_made"
                ) ?
                "block" : "none"
            )
        );

        $("#id_cost_unit").on(
            "change",
            event => {
                const otherIsSelected = ($(event.target).find(":selected").val() === "other");

                $(".field-cost_unit_other").
                css(
                    "display",
                    (
                        (otherIsSelected) ?
                        "block" : "none"
                    )
                );

                if (!otherIsSelected) $(".field-cost_unit_other").val("");
            }
        );

        $("#id_paper_form_state").on(
            "change",
            event => {
                const notStoredOrShredded = (
                    !["never_made", "stored", "shredded", "lost"].includes(
                        $(event.target).find(":selected").val()
                    )
                );

                const notNeverMade = (
                    $(event.target).find(":selected").val() !== "never_made"
                )

                $(".field-paper_form_person_responsible").
                css(
                    "display",
                    (
                        (notStoredOrShredded) ?
                        "block" : "none"
                    )
                );

                $(".field-filing_area").
                css(
                    "display",
                    (
                        (notNeverMade) ?
                        "block" : "none"
                    )
                );

                if (!notStoredOrShredded) {
                    $("#id_paper_form_person_responsible").val("");
                }
            }
        );
    }
);
