# Generated by Django 4.1.4 on 2023-02-03 04:50

import django.db.models.deletion
import django.utils.timezone
import django_countries.fields
import markdownx.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "sso_id",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that SSO ID already exists."
                        },
                        max_length=150,
                        unique=True,
                        verbose_name="SSO ID",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "user",
                "verbose_name_plural": "users",
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Contract",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("primary", "Hlavní"),
                            ("amendment", "Dodatek"),
                            ("framework_order", "Objednávka u rámcové smlouvy"),
                        ],
                        default="primary",
                        max_length=15,
                        verbose_name="Typ",
                    ),
                ),
                (
                    "contains_nda",
                    models.BooleanField(default=False, verbose_name="Obsahuje NDA"),
                ),
                (
                    "is_anonymized",
                    models.BooleanField(default=False, verbose_name="Je anonymizovaná"),
                ),
                (
                    "external_signer_signature_date",
                    models.DateField(verbose_name="Datum podpisu druhé strany"),
                ),
                (
                    "local_signer_signature_date",
                    models.DateField(verbose_name="Datum podpisu naší strany"),
                ),
                (
                    "all_parties_sign_date",
                    models.DateField(verbose_name="Datum podpisu všech stran"),
                ),
                (
                    "valid_start_date",
                    models.DateField(verbose_name="Začátek účinnosti"),
                ),
                ("valid_end_date", models.DateField(verbose_name="Začátek platnosti")),
                (
                    "legal_state",
                    models.CharField(
                        choices=[
                            ("valid", "Platná"),
                            ("effective", "Účinná"),
                            ("not_effective", "Neúčinná"),
                            ("invalid", "Neplatná"),
                        ],
                        max_length=13,
                        verbose_name="Stav právního ujednání",
                    ),
                ),
                (
                    "public_state",
                    models.CharField(
                        choices=[
                            ("unknown", "Nová"),
                            ("yes", "Zveřejněná"),
                            ("no", "Neveřejná"),
                        ],
                        max_length=7,
                        verbose_name="Veřejnost smlouvy",
                    ),
                ),
                (
                    "paper_form_state",
                    models.CharField(
                        choices=[
                            ("sent", "Odeslaná"),
                            ("stored", "Uložená"),
                            ("to_shred", "Ke skartaci"),
                            ("shredded", "Skartovaná"),
                        ],
                        max_length=8,
                        verbose_name="Stav papírové formy",
                    ),
                ),
                (
                    "publishing_rejection_comment",
                    models.CharField(
                        blank=True,
                        max_length=65536,
                        null=True,
                        verbose_name="Důvod nezveřejnění",
                    ),
                ),
                (
                    "tender_url",
                    models.URLField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Odkaz na výběrové řízení",
                    ),
                ),
                (
                    "identifier",
                    models.CharField(
                        max_length=128, verbose_name="Identifikační číslo"
                    ),
                ),
                (
                    "summary",
                    models.CharField(
                        blank=True,
                        max_length=65536,
                        null=True,
                        verbose_name="Rekapitulace",
                    ),
                ),
                (
                    "contract_file",
                    models.FileField(upload_to="", verbose_name="Smlouva (PDF)"),
                ),
                (
                    "expected_cost_total",
                    models.IntegerField(verbose_name="Očekáváná celková cena"),
                ),
                (
                    "expected_cost_year",
                    models.IntegerField(verbose_name="Očekáváná cena za rok"),
                ),
                (
                    "expected_cost_month",
                    models.IntegerField(verbose_name="Očekáváná cena za měsíc"),
                ),
                (
                    "expected_cost_hour",
                    models.IntegerField(verbose_name="Očekáváná cena za hodinu"),
                ),
                (
                    "intent_url",
                    models.URLField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Odkaz na záměr",
                    ),
                ),
                (
                    "agreement_url",
                    models.URLField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Odkaz na schválení",
                    ),
                ),
            ],
            options={
                "verbose_name": "Smlouva",
                "verbose_name_plural": "Smlouvy",
            },
        ),
        migrations.CreateModel(
            name="ContractExternalSigner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "is_legal_entity",
                    models.BooleanField(verbose_name="Je právnická osoba"),
                ),
                (
                    "address_street_with_number",
                    models.CharField(max_length=256, verbose_name="Ulice, č.p."),
                ),
                (
                    "address_district",
                    models.CharField(max_length=256, verbose_name="Obec"),
                ),
                ("address_zip", models.CharField(max_length=16, verbose_name="PSČ")),
                (
                    "address_country",
                    django_countries.fields.CountryField(
                        max_length=2, verbose_name="Země"
                    ),
                ),
                (
                    "ico_number",
                    models.CharField(
                        blank=True, max_length=16, null=True, verbose_name="IČO"
                    ),
                ),
                (
                    "date_of_birth",
                    models.DateField(
                        blank=True, null=True, verbose_name="Datum narození"
                    ),
                ),
                (
                    "representative_name",
                    models.CharField(
                        blank=True, max_length=256, null=True, verbose_name="Zástupce"
                    ),
                ),
                (
                    "representative_role",
                    models.CharField(
                        blank=True,
                        max_length=256,
                        null=True,
                        verbose_name="Funkce zástupce",
                    ),
                ),
                (
                    "department",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="Organizační složka",
                    ),
                ),
            ],
            options={
                "verbose_name": "Druhá smluvní strana",
                "verbose_name_plural": "Druhé smluvní strany",
            },
        ),
        migrations.CreateModel(
            name="ContractFilingArea",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
                (
                    "person_responsible",
                    models.CharField(max_length=256, verbose_name="Odpovědná osoba"),
                ),
            ],
            options={
                "verbose_name": "Spisovna",
                "verbose_name_plural": "Spisovny",
            },
        ),
        migrations.CreateModel(
            name="ContractIssue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
            ],
            options={
                "verbose_name": "Problém se smlouvou",
                "verbose_name_plural": "Problémy se smlouvou",
            },
        ),
        migrations.CreateModel(
            name="ContractLocalSigner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, verbose_name="Jméno")),
                (
                    "address_street_with_number",
                    models.CharField(max_length=256, verbose_name="Ulice, č.p."),
                ),
                (
                    "address_district",
                    models.CharField(max_length=256, verbose_name="Obec"),
                ),
                ("address_zip", models.CharField(max_length=16, verbose_name="PSČ")),
                (
                    "address_country",
                    django_countries.fields.CountryField(
                        max_length=2, verbose_name="Země"
                    ),
                ),
                (
                    "ico_number",
                    models.CharField(
                        blank=True, max_length=16, null=True, verbose_name="IČO"
                    ),
                ),
                ("color", models.CharField(max_length=6, verbose_name="Barva")),
            ],
            options={
                "verbose_name": "Naše smluvní strana",
                "verbose_name_plural": "Naše smlouvní strany",
            },
        ),
        migrations.CreateModel(
            name="ContractSubtype",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=32, verbose_name="Jméno")),
            ],
            options={
                "verbose_name": "Podtyp smlouvy",
                "verbose_name_plural": "Podtypy smlouvy",
            },
        ),
        migrations.CreateModel(
            name="ContractNote",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_date", models.DateTimeField(verbose_name="Datum vytvoření")),
                ("content", markdownx.models.MarkdownxField(verbose_name="Obsah")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contract_notes",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Autor",
                    ),
                ),
                (
                    "contract",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="shared.contract",
                    ),
                ),
            ],
            options={
                "verbose_name": "Poznámka ke smlouvě",
                "verbose_name_plural": "Poznámky ke smlouvě",
            },
        ),
        migrations.AddField(
            model_name="contract",
            name="external_signer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="shared.contractexternalsigner",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="filing_area",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="shared.contractfilingarea",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="issues",
            field=models.ManyToManyField(to="shared.contractissue"),
        ),
        migrations.AddField(
            model_name="contract",
            name="local_signer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="shared.contractlocalsigner",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="primary_contract",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="shared.contract",
                verbose_name="Hlavní smlouva",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="public_status_set_by",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="public_status_altered_contracts",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Zveřejněno / nezveřejněno uživatelem",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="subtype",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="shared.contractsubtype",
                verbose_name="Podtyp",
            ),
        ),
        migrations.AddField(
            model_name="contract",
            name="uploaded_by",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="uploaded_contracts",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Nahráno uživatelem",
            ),
        ),
    ]
