from django.template import Library

from shared.admin import FieldsetInlineOrder

register = Library()


@register.simple_tag(takes_context=True)
def get_fieldsets_and_inlines(context):
    adminform = context["adminform"]
    model_admin = adminform.model_admin

    adminform = iter(adminform)
    inlines = iter(context["inline_admin_formsets"])

    fieldsets_and_inlines = []

    for choice in (
        model_admin.get_fieldsets_and_inlines_order(context)
        if hasattr(model_admin, "get_fieldsets_and_inlines_order")
        else (
            model_admin.fieldsets_and_inlines_order
            if hasattr(model_admin, "fieldsets_and_inlines_order")
            else []
        )
    ):
        try:
            if choice == FieldsetInlineOrder.FIELDSET:
                fieldsets_and_inlines.append(
                    (FieldsetInlineOrder.FIELDSET, next(adminform))
                )
            elif choice == FieldsetInlineOrder.INLINE:
                fieldsets_and_inlines.append(
                    (FieldsetInlineOrder.INLINE, next(inlines))
                )
        except StopIteration:
            # Missing permissions, ignore and move on
            continue

    for fieldset in adminform:
        fieldsets_and_inlines.append((FieldsetInlineOrder.FIELDSET, fieldset))

    for inline in inlines:
        fieldsets_and_inlines.append((FieldsetInlineOrder.INLINE, inline))

    return fieldsets_and_inlines
