"""URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import include, path, re_path
from django.views.static import serve
from pirates.urls import urlpatterns as pirates_urlpatterns

import registry.admin

urlpatterns = [
    path("", include("contracts.urls")),
    path("markdownx/", include("markdownx.urls")),
    path("oidc/", include("oidc.urls")),
    path("media/", include("media_server.urls")),
    path("admin/", admin.site.urls),
    path("settings/", include("dbsettings.urls")),
] + pirates_urlpatterns

handler404 = "contracts.views.handle_404"
