import copy

from django.conf import settings
from django.contrib import admin
from django_admin_index.models import AppGroup, AppGroupQuerySet


def get_app_list(self, request):
    app_dict = self._build_app_dict(request)

    for app_name, object_list in app_dict.items():
        if app_name in settings.ADMIN_ORDERING:
            app = app_dict[app_name]
            app["models"].sort(
                key=lambda model: settings.ADMIN_ORDERING[app_name].index(
                    model["object_name"]
                )
            )
            app_dict[app_name]

            yield app
        else:
            yield app_dict[app_name]


admin.AdminSite.get_app_list = get_app_list


original_as_list_func = copy.deepcopy(AppGroupQuerySet.as_list)


def as_list(self, request, include_remaining=True):
    result = original_as_list_func(self, request, include_remaining=include_remaining)

    for item in result:
        if item["app_label"] not in settings.ADMIN_ORDERING:
            continue

        item["models"].sort(
            key=lambda model: (
                settings.ADMIN_ORDERING[item["app_label"]].index(model["object_name"])
            )
        )

    return result


AppGroupQuerySet.as_list = as_list
