import { Helmet } from "react-helmet";

import PageTitle from "components/PageTitle";
import { basics } from "config";

import Button from "components/Button";
import VenueCard from "components/VenueCard";
import { venues } from "config";

import prvni_patro from "../ihz1.jpg";
import druhe_patro from "../ihz2.jpg";
import treti_patro from "../ihzlinmapa.png";

const Meeting = () => {
  const venueItem = venues[1];
  return (
    <article className="w-full">
      <PageTitle>Zasedání CF</PageTitle>

      <Helmet>
        <title>Zasedání CF | {basics.appTitle}</title>
        <meta property="og:title" content="Workshopy" />
      </Helmet>

      <div className="content-block">
        <h2>Zasedání Celostátního fóra ve Zlíně</h2>
        <p>
Zasedání svolal 2. prosince 2024 předseda strany Zdeněk Hřib.
        </p>

        <p>
<b>Zasedání je svoláno na sobotu 15. února 2025 od 9:00 do 18:00 do Zlína.</b><br/>Členům bude umožněna vzdálená účast.</p>
<p>Hlavním <a href="/organizatori">organizátorem</a> je Marek Houser.
        </p><p>&nbsp;</p>
      </div>
{/*

      <Button
        className="text-lg btn--to-blue-300 mb-2"
        bodyClassName="whitespace-no-wrap"
        color="black"
        href="program#sobota 9. 11. 2024"
        icon="ico--chevron-right"
      >
        Pořad zasedání
      </Button>
      &nbsp;
      */}
      <Button
        className="text-lg btn--to-blue-300 mb-2"
        bodyClassName="whitespace-no-wrap"
        color="black"
        href="https://a.pirati.cz/cf/2025-02/"
        icon="ico--chevron-right"
        target="_blank"
      >
        Podklady ke stažení
      </Button>


      <div className="content-block">
        <p>
          <img
            src={prvni_patro}
            alt="Exterier"
            className="block w-128 mt-4 mb-4"
          />

        </p>
        <p>
          <img
            src={druhe_patro}
            alt="Sal"
            className="block w-128 mt-4 mb-4"
          />

        </p>
        <p>
          <img
            src={treti_patro}
            alt="Mapa salu"
            className="block w-128 mt-4 mb-4"
          />

        </p>
      </div>


      <div className="content-block p-2">
      </div>

      <div className="grid md:grid-cols-2 gap-4 md:gap-4 content-block">
        <VenueCard
          street={venueItem.street}
          city={venueItem.city}
          gps={venueItem.gps}
          href={venueItem.href}
          title_short={venueItem.title_short}
        />
      </div>

    </article>
  );
};

export default Meeting;
