import React from "react";

import Button from "components/Button";
import {
  Card,
  CardActions,
  CardBody,
  CardBodyText,
  CardHeadline,
} from "components/cards";

import Modal from "./Modal";

const ModalConfirm = ({
  title,
  children,
  yesActionLabel = "OK",
  cancelActionLabel = "Zrušit",
  onCancel,
  onConfirm,
  ...props
}) => {
  return (
    <Modal containerClassName="max-w-md" onRequestClose={onCancel} {...props}>
      <Card>
        <CardBody>
          <div className="flex items-center justify-between mb-4">
            <CardHeadline>{title}</CardHeadline>
            <button onClick={onCancel}>
              <i className="ico--close"></i>
            </button>
          </div>
          <CardBodyText>{children}</CardBodyText>
        </CardBody>
        <CardActions right className="space-x-1">
          <Button
            hoverActive
            color="blue-300"
            className="text-sm"
            onClick={onConfirm}
          >
            {yesActionLabel}
          </Button>
          <Button
            hoverActive
            color="red-600"
            className="text-sm"
            onClick={onCancel}
          >
            {cancelActionLabel}
          </Button>
        </CardActions>
      </Card>
    </Modal>
  );
};

export default ModalConfirm;
