import React from "react";
import Modal from "react-modal";
import classNames from "classnames";

const CustomModal = ({ children, containerClassName, ...props }) => (
  <Modal
    contentLabel={props.headline}
    overlayClassName="modal__overlay"
    className="modal__content"
    {...props}
  >
    <div className={classNames("modal__container w-full", containerClassName)}>
      <div className="modal__container-body">{children}</div>
    </div>
  </Modal>
);

export default CustomModal;
