import basicPhotoBannerImage from "./assets/previews/basic_photo_banner.png";
import urgentBasicPhotoBannerImage from "./assets/previews/urgent_basic_photo_banner.png";
import makeawishPhotoBannerImage from "./assets/previews/make_a_wish_photo_banner.png";
import makeawishTourSocialImage from "./assets/previews/make_a_wish_tour_social.png";
import backInFullForcePhotoBannerImage from "./assets/previews/back_in_full_force_photo_banner.png";
import urgentTextBannerImage from "./assets/previews/urgent_text_banner.png";
import textBannerImage from "./assets/previews/text_banner.png";
import newspaperQuoteBottomImage from "./assets/previews/newspaper_quote_bottom.png";
import newspaperQuoteMiddleImage from "./assets/previews/newspaper_quote_middle.png";
import facebookSurveyImage from "./assets/previews/facebook_survey.png";
import twitterBannerImage from "./assets/previews/twitter_banner.png";
import posterImage from "./assets/previews/poster.png";
import eventPosterImage from "./assets/previews/event_poster.png";
import regionalSuccessImage from "./assets/previews/regional_success.png";
import socialCoverLargeTextImage from "./assets/previews/social_cover_large_text.png";
import reelImage from "./assets/previews/reel.png";

import baseEventImage from "./assets/previews/base_event.png";
import rightEventImage from "./assets/previews/right_event.png";
import angleEventRightImage from "./assets/previews/angle_event_right.png";
import angleEventLeftImage from "./assets/previews/angle_event_left.png";

// import basePersonEventImage from "./assets/previews/base_person_event.png";
// import rightPersonEventImage from "./assets/previews/right_person_event.png";
// import anglePersonEventRightImage from "./assets/previews/angle_person_event_right.png";
// import anglePersonEventLeftImage from "./assets/previews/angle_person_event_left.png";

import peopleBannerWithPredefinedTextImage from "./assets/previews/people_banner_with_predefined_text.png";
import peopleBannerWithCustomTextImage from "./assets/previews/people_banner_with_predefined_text.png";

const TEMPLATES = {
  basic_photo_banner: {
    name: "Základní banner s fotkou",
    image: basicPhotoBannerImage,
    path: "/",
    component: () => import("./views/basic_photo_banner/BasicPhotoBanner.vue"),
    meta: {
      title: "Základní banner s fotkou",
    },
  },
  urgent_basic_photo_banner: {
    name: "Urgentní banner s fotkou",
    image: urgentBasicPhotoBannerImage,
    path: "/urgent-basic-photo-banner",
    component: () =>
      import("./views/urgent_basic_photo_banner/UrgentBasicPhotoBanner.vue"),
    meta: {
      title: "Urgentní banner s fotkou",
    },
  },
  make_a_wish_banner: {
    name: "Máte přání banner",
    image: makeawishPhotoBannerImage,
    path: "/make-a-wish-banner",
    component: () => import("./views/make_a_wish_banner/MakeAWishBanner.vue"),
    meta: {
      title: "Máte přání banner",
    },
  },
  make_a_wish_banner: {
    name: "Máte tour banner na soc. sítě",
    image: makeawishPhotoBannerImage,
    path: "/make-a-wish-tour-social",
    component: () => import("./views/make_a_wish_tour_social/MakeAWishTourSocial.vue"),
    meta: {
      title: "Máte tour banner na soc. sítě",
    },
  },
  back_in_full_force_banner: {
    name: "Zpátky v plné síle banner",
    image: backInFullForcePhotoBannerImage,
    path: "/back-in-full-force-banner",
    component: () => import("./views/back_in_full_force_banner/BackInFullForceBanner.vue"),
    meta: {
      title: "Zpátky v plné síle banner",
    },
  },
  urgent_text_banner: {
    name: "Urgentní banner pouze s textem",
    image: urgentTextBannerImage,
    path: "/urgent-text-banner",
    component: () => import("./views/urgent_text_banner/UrgentTextBanner.vue"),
    meta: {
      title: "Urgentní banner pouze s textem",
    },
  },
  text_banner: {
    name: "Banner pouze s textem",
    image: textBannerImage,
    path: "/text-banner",
    component: () => import("./views/text_banner/TextBanner.vue"),
    meta: {
      title: "Banner pouze s textem",
    },
  },
  newspaper_quote_bottom: {
    name: "Novinová citace s obrázkem",
    image: newspaperQuoteBottomImage,
    path: "/newspaper-quote-bottom",
    component: () =>
      import("./views/newspaper_quote_bottom/NewspaperQuoteBottom.vue"),
    meta: {
      title: "Novinová citace s obrázkem",
    },
  },
  newspaper_quote_middle: {
    name: "Novinová citace - pouze text",
    image: newspaperQuoteMiddleImage,
    path: "/newspaper-quote-middle",
    component: () =>
      import("./views/newspaper_quote_middle/NewspaperQuoteMiddle.vue"),
    meta: {
      title: "Novinová citace - pouze text",
    },
  },
  facebook_survey: {
    name: "Facebook anketa",
    image: facebookSurveyImage,
    path: "/facebook-survey",
    component: () => import("./views/facebook_survey/FacebookSurvey.vue"),
    meta: {
      title: "Facebook anketa",
    },
  },
  poster: {
    name: "Plakát",
    image: posterImage,
    path: "/poster",
    component: () => import("./views/poster/Poster.vue"),
    meta: {
      title: "Plakát",
    },
  },
  event_poster: {
    name: "Plakát - událost",
    image: eventPosterImage,
    path: "/event-poster",
    component: () => import("./views/event_poster/EventPoster.vue"),
    meta: {
      title: "Plakát - událost",
    },
  },
  twitter_banner: {
    name: "Twitter banner",
    image: twitterBannerImage,
    path: "/twitter-banner",
    component: () => import("./views/twitter_banner/TwitterBanner.vue"),
    meta: {
      title: "Twitter banner",
    },
  },
  regional_success: {
    name: "Povedlo se v kraji",
    image: regionalSuccessImage,
    path: "/regional-success",
    component: () => import("./views/regional_success/RegionalSuccess.vue"),
    meta: {
      title: "Povedlo se v kraji",
    },
  },
  base_event: {
    name: "Událost - pouze text, vprostřed",
    image: baseEventImage,
    path: "/base-event",
    component: () => import("./views/base_event/BaseEvent.vue"),
    meta: {
      title: "Událost - pouze text, vprostřed",
    },
  },
  right_event: {
    name: "Událost - pouze text, vpravo",
    image: rightEventImage,
    path: "/right-event",
    component: () => import("./views/right_event/RightEvent.vue"),
    meta: {
      title: "Událost - pouze text, vpravo",
    },
  },
  angle_event_right: {
    name: "Událost - pruh pod úhlem, vpravo",
    image: angleEventRightImage,
    path: "/angle-event-right",
    component: () => import("./views/angle_event_right/AngleEventRight.vue"),
    meta: {
      title: "Událost - pruh pod úhlem, vpravo",
    },
  },
  angle_event_left: {
    name: "Událost - pruh pod úhlem, vlevo",
    image: angleEventLeftImage,
    path: "/angle-event-left",
    component: () => import("./views/angle_event_left/AngleEventLeft.vue"),
    meta: {
      title: "Událost - pruh pod úhlem, vlevo",
    },
  },

  social_cover_large_text: {
    name: "Cover na sociální sítě - velký text",
    image: socialCoverLargeTextImage,
    path: "/social-cover-large-text",
    component: () =>
      import("./views/social_cover_large_text/SocialCoverLargeText.vue"),
    meta: {
      title: "Cover na sociální sítě - velký text",
    },
  },

  reel: {
    name: "Reel na sociální sítě",
    image: reelImage,
    path: "/reel",
    component: () => import("./views/reel/Reel.vue"),
    meta: {
      title: "Reel na sociální sítě",
    },
  },

  // NOTE: The following 2 templates have been disabled on request.
  // https://zulip.pirati.cz/#narrow/stream/1545-MoTo/topic/gener.C3.A1tor/near/3390404
  //
  // people_banner_with_predefined_text: {
  //   name: 'Osoba v šipce s textem "Odvaha pro Evropu"',
  //   image: peopleBannerWithPredefinedTextImage,
  //   path: "/people-banner-with-predefined-text",
  //   component: () =>
  //     import(
  //       "./views/people_banner_with_predefined_text/PeopleBannerWithPredefinedText.vue"
  //     ),
  //   meta: {
  //     title: 'Osoba v šipce s textem "Odvaha pro Evropu"',
  //   },
  // },
  // people_banner_with_custom_text: {
  //   name: "Osoba v šipce s vlastním textem",
  //   image: peopleBannerWithCustomTextImage,
  //   path: "/people-banner-with-custom-text",
  //   component: () =>
  //     import(
  //       "./views/people_banner_with_custom_text/PeopleBannerWithCustomText.vue"
  //     ),
  //   meta: {
  //     title: "Osoba v šipce s vlastním textem",
  //   },
  // },

  // base_person_event: {
  //   name: "Událost - text a obrázek na pozadí, vprostřed",
  //   image: basePersonEventImage,
  //   path: "/base-person-event",
  //   component: () => import("./views/base_person_event/BasePersonEvent.vue"),
  //   meta: {
  //     title: "Událost - text a obrázek na pozadí, vprostřed",
  //   },
  // },
  // right_person_event: {
  //   name: "Událost - text a obrázek na pozadí, vpravo",
  //   image: rightPersonEventImage,
  //   path: "/right-person-event",
  //   component: () => import("./views/right_person_event/RightPersonEvent.vue"),
  //   meta: {
  //     title: "Událost - text a obrázek na pozadí, vpravo",
  //   },
  // },
  // angle_person_event_right: {
  //   name: "Událost - pruh pod úhlem s obrázkem na pozadí, vpravo",
  //   image: anglePersonEventRightImage,
  //   path: "/angle-person-event-right",
  //   component: () =>
  //     import("./views/angle_person_event_right/AnglePersonEventRight.vue"),
  //   meta: {
  //     title: "Událost - pruh pod úhlem s obrázkem na pozadí, vpravo",
  //   },
  // },
  // angle_person_event_left: {
  //   name: "Událost - pruh pod úhlem s obrázkem na pozadí, vlevo",
  //   image: anglePersonEventLeftImage,
  //   path: "/angle-person-event-left",
  //   component: () =>
  //     import("./views/angle_person_event_left/AnglePersonEventLeft.vue"),
  //   meta: {
  //     title: "Událost - pruh pod úhlem s obrázkem na pozadí, vlevo",
  //   },
  // },
};

export default TEMPLATES;
