package CF2022::Schema::Result::Order;

use strict;
use warnings;

use base 'DBIx::Class::Core';
use JSON;

our $VERSION = 1;

__PACKAGE__->table('orders');

__PACKAGE__->add_columns(
    qw(
        id
        created
        deleted
        paid
        ip
        sso_uuid
        order_id
        email
        api
        request
        response
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->inflate_column('request', {
    inflate => sub {
        return from_json(shift);
    },
    deflate => sub {
        return to_json(shift);
    },
});

__PACKAGE__->inflate_column('response', {
    inflate => sub {
        return from_json(shift);
    },
    deflate => sub {
        return to_json(shift);
    },
});

1;
