package CF2022::Helpers::Core;

use base 'Mojolicious::Plugin';
use feature 'signatures';
no warnings qw{ experimental::signatures } ;

use YAML;
use Mojo::JWT;

sub register ($class, $self, $conf) {

    $self->helper(error => sub ($c, $status, $msg) {

        if ( ref $msg eq 'ARRAY' ) {
            $errors = $msg;
        }
        elsif ( ref $msg eq 'HASH' ) {
            $errors = [ $msg ];
        }
        else {
            $errors = [{
                message => $msg,
                path    => $c->stash('openapi.path'),
            }];
        }

        $c->stash(
            status  => $status,
            openapi => {
                status  => $status,
                errors => $errors,
            },
        );

        return undef;
    });

    $self->helper( trace => sub( $c, $data='' ) {
        $data = Dump $data if ref $data;
        $c->app->log->debug($data);

    });

    $self->helper( spec_filter => sub ($c, $data, $class) {

        if (my $def =$c->openapi->spec("/components/schemas/$class")) {
            my $filtered = {};

            KEY:
            foreach my $key ( keys %{ $def->{properties} } ) {
                my $value    = $data->{$key};
                my $nullable = 0;

                my $types = $def->{properties}{$key}{type};

                if ( ref $types eq 'ARRAY' ) {
                    TYPE:
                    foreach my $type ( @{ $types } ) {
                        $nullable = 1, last if $type eq 'null';
                    }
                }

                $filtered->{$key} = $value;
            }

            $data = $filtered;

        }

        return $data;
    });

    $self->helper(mapped_product_id => sub ($c, $id) {
        my %map = (split /\D+/, $c->cfg->{pretix_products_map});
        return (exists $map{$id}) ? $map{$id} : $id;
    });

    $self->helper(mapped_variation_id => sub ($c, $id) {
        my %map = (split /\D+/, $c->cfg->{pretix_variations_map});
        return (exists $map{$id}) ? $map{$id} : $id;
    });
}

1;

