package CF::Schema::ResultSet::Announcement;

use strict;
use warnings;
use utf8;
use feature 'signatures';
no warnings qw{ experimental::signatures };

use base 'DBIx::Class::ResultSet';

use constant PROTECTED_FIELDS => [qw(
    id
    datetime
    deleted
    user_id
    type
)];

use constant TEMPLATE => {
    0 => 'Předsedající prohlásil návrh postupu předložený **%s** za nepřijatelný ' .
         'a dál k němu nepřihlíží // **§4 (2) JdŘ CF**',
    1 => 'Byl schválen návrh postupu, předložený **%s** ' .
         'v následujícím znění: *"%s"*',
    2 => 'Předsedající zaznamenal přijatelný návrh postupu, předložený **%s** ' .
         'v následujícím znění: *"%s"*. ' .
         'O návrhu postupu se hlasuje bezodkladně // **§10 (2) JdŘ CF**',
    5 => 'Předsedající, pořádkovým opatřením, vykázal z jednání **%s** // **§2 (1) JdŘ CF**',
};

sub from_template ( $class, $id, @args ) {
    my $template = TEMPLATE->{$id} // return '';

    return sprintf($template, @args);
}

1;
