package CF::Schema::Result::ProgramEntry;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('program');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        event_id
        number
        start
        finish
        is_approved
        is_live
        discussion_opened
        title
        proposer
        speakers
        vote
        description
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->has_many(
    posts => 'CF::Schema::Result::Post',
    { 'foreign.program_entry_id' => 'self.id', },
);

1;
