package CF::Schema::Result::PostRanking;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('posts_ranking');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        user_id
        post_id
        ranking
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraint(
    'post_user' => [qw(user_id post_id)]
);

__PACKAGE__->has_one( view => 'CF::Schema::Result::Post_view', 'id');

__PACKAGE__->belongs_to(
    user => 'Zircon::Schema::Result::User',
    {
        'foreign.id' => 'self.user_id',
    },
);

__PACKAGE__->belongs_to(
    post => 'Zircon::Schema::Result::Post',
    {
        'foreign.id' => 'self.post_id',
    },
);

1;
