package CF::Schema::Result::EventACL;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('events_acl');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        event_id
        subject_class
        subject
        role
    ),
);

__PACKAGE__->belongs_to(
    event => 'CF::Schema::Result::Event',
    {
        'foreign.id' => 'self.event_id',
    },
);

1;
