package CF::Schema::Result::Post_view;

use strict;
use warnings;

use base 'CF::Schema::Result::Post';

our $VERSION = 1;

__PACKAGE__->table('posts_view');

__PACKAGE__->add_columns(
    qw(
        score
        user_name
        group_name
    ),
);

__PACKAGE__->set_primary_key('id');

sub format {
    my $self = shift;

    my $post = {
        id         => $self->id,
        datetime   => $self->datetime,
        type       => $self->type,
        is_archive => $self->is_archived,
        author => {
            name  => $self->user_name,
            group => $self->group_name,
        },
        ranking => {
            score    => $self->score,
            likes    => $self->likes,
            dislikes => $self->dislikes,
            my_vote  => 0, #TODO
        }
    };

    return $post;

}


1;
