package CF::Schema::Result::Announcement;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('announcements');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        datetime
        is_archived
        user_id
        type
        state
        content
        link
        related_post_id
    ),
);

__PACKAGE__->set_primary_key('id');

1;


