package CF::Controller::Posts;
use Mojo::Base 'Mojolicious::Controller';

sub create {
    my $c    = shift->openapi->valid_input or return;
    my $args = $c->req->json;

    # Navrh postupu muze predlozit jenom clen
    if ( $args->{type} == 0 && ! $c->user_roles->{'xember'} ) {
        return $c->error(401, 'Insufficient permissions');
    }

    my $post = $c->schema->resultset('Post')->create({
        user_id => $c->user->{id},
        type    => $args->{type},
        content => $args->{content},
    });

    ### TODO: Notify

    $c->render(
        status  => 201,
        openapi => { id => $post->id },
    );
};

1;
