package CF::Schema::Result::User;

use strict;
use warnings;

use base 'DBIx::Class::Core';

our $VERSION = 1;

__PACKAGE__->table('users');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        uuid
        is_active
        username
        name
        main_group_name
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraint(
    'uuid' => [qw(uuid)]
);

__PACKAGE__->has_many(
    posts => 'CF::Schema::Result::Post',
    { 'foreign.user_id' => 'self.id', },
);

1;
