package CF::Schema::Result::Post_view;

use strict;
use warnings;

use base 'CF::Schema::Result::Post';

our $VERSION = 1;

__PACKAGE__->table('posts_view');

__PACKAGE__->add_columns(
    qw(
        ranking_score
        user_name
        user_name
        group_name
    ),
);

__PACKAGE__->set_primary_key('id');

sub format {
    my $self = shift;

    my $post = {
        id          => $self->id,
        datetime    => $self->datetime,
        type        => $self->type,
        state       => $self->state,
        content     => $self->content,
        is_archived => $self->is_archived,
        is_changed  => $self->changed ? 1 : 0,
        author => {
            id       => $self->user_id,
            name     => $self->user_name,
            group    => $self->group_name,
            username => $self->user_username,
        },
        ranking => {
            score    => $self->ranking_score,
            likes    => $self->ranking_likes,
            dislikes => $self->ranking_dislikes,
            my_vote  => 0,
        },
        history_log => []
    };

    return $post;

}


1;
