package CF::Helpers::Core;

use base 'Mojolicious::Plugin';
use feature 'signatures';
no warnings qw{ experimental::signatures } ;

use YAML;

sub register ($class, $self, $conf) {

    $self->helper(error => sub ($c, $status, $msg) {

        if ( ref $msg eq 'ARRAY' ) {
            $errors = $msg;
        }
        elsif ( ref $msg eq 'HASH' ) {
            $errors = [ $msg ];
        }
        else {
            $errors = [{
                message => $msg,
                path    => $c->stash('openapi.path'),
            }];
        }

        $c->stash(
            status  => $status,
            openapi => {
                status  => $status,
                errors => $errors,
            },
        );

        return undef;
    });

    $self->helper( trace => sub( $c, $data='' ) {
        $data = Dump $data if ref $data;
        $c->app->log->debug($data);

    });

    $self->helper( spec_filter => sub ($c, $data, $class) {

        if (my $def =$c->openapi->spec("/components/schemas/$class")) {
            my $filtered = {};

            KEY:
            foreach my $key ( keys %{ $def->{properties} } ) {
                my $value    = $data->{$key};
                my $nullable = 0;

                my $types = $def->{properties}{$key}{type};

                if ( ref $types eq 'ARRAY' ) {
                    TYPE:
                    foreach my $type ( @{ $types } ) {
                        $nullable = 1, last if $type eq 'null';
                    }
                }

                $filtered->{$key} = $value;
            }

            $data = $filtered;

        }

        return $data;
    });

    $self->helper( search_parametrs => sub( $c, $args ) {
        my $conditions = {};
        if ( ref $args->{filter} eq 'ARRAY' ) {
            CONDITION:
            foreach my $condition ( @{ $args->{filter} } ) {
                my ( $column, $op, $arg ) = split /:/, $condition;
                my @columns = split /\|/, $column;
                my @args    = split /\|/, $arg;

                if ( $op eq 'match' ) {
                    $op  = 'ilike';
                    @args = map { '%' . $_ . '%' } @args;
                }
                elsif ( $op =~ /^beg/i ) {
                    $op  = 'ilike';
                    @args = map { $_ . '%' } @args;
                }
                elsif ( $op =~ /^end/i ) {
                    $op  = 'ilike';
                    @args = map { '%' . $_ } @args;
                }
                else {
                    if ( scalar @args > 1 ) {
                        $op = 'in';
                    }
                    else {
                        $op = '=';
                    }
                }

                if ( scalar @columns > 1 ) {
                    $conditions->{ -or } = [
                        map { $_ => { $op => \@args }} @columns
                    ];
                }
                else {
                    $conditions->{ $column } = { $op => \@args };
                }
            }
        }

        if ( $args->{fulltext} ) {
            $conditions->{fulltext} = { ilike => '%' . $args->{fulltext} . '%'};
        }

        my @order_by = ();
        if ( ref $args->{sort} eq 'ARRAY' ) {
            COLUMN:
            foreach my $column ( @{ $args->{sort} } ) {
                $column =~ s/^(\W)*//;

                if ( $1 && $1 eq '-' ) {
                    push @order_by, { -desc => $column };
                }
                else {
                    push @order_by, $column;
                }
            }
        }

        return (
            $conditions,
            {
                order_by => \@order_by,
#                columns  => $args->{columns},
                rows     => $args->{limit},
                offset   => $args->{offset},
            }
        );
    });

    $self->helper( format_timestamp => sub($c, $timestamp, $format) {
        return $timestamp;
    });
}

1;

