package CF::Schema::Result::User;

use strict;
use warnings;

use base 'DBIx::Class::Core';

use Data::Random qw(rand_chars);

our $VERSION = 1;

__PACKAGE__->table('users');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'integer',
        is_auto_increment => 1,
        is_nullable       => 0,
        sequence          => 'uid_seq'
    },
    qw(
        uuid
        is_active
        username
        secret
        name
        main_group_name
        keepalive
        banned_until
    ),
);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraint(
    'uuid' => [qw(uuid)]
);

__PACKAGE__->has_many(
    posts => 'CF::Schema::Result::Post',
    { 'foreign.user_id' => 'self.id', },
);

sub formatted {
    my $self = shift;

    my $user = {
        $self->get_columns,
        group => $self->main_group_name,
        is_banned => $self->banned_until ? 1:0,
    };

    return $user;

}

sub set_secret {
    my $self = shift;
    my $new  = shift;

    return if $self->secret and not $new;

    my $secret = rand_chars( set => 'alphanumeric', size => 16 );

    $self->update({
        secret => $secret
    });

}

1;
